/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.consul.config.ConsulBootstrapper;
import org.springframework.cloud.consul.config.ConsulConfigDataResource;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.util.StringUtils;

public class ConsulConfigDataLoader
implements ConfigDataLoader<ConsulConfigDataResource> {
    private static final EnumSet<ConfigData.Option> ALL_OPTIONS = EnumSet.allOf(ConfigData.Option.class);
    private final Log log;

    public ConsulConfigDataLoader(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(ConsulConfigDataLoader.class);
    }

    public ConfigData load(ConfigDataLoaderContext context, ConsulConfigDataResource resource) {
        ConsulBootstrapper.LoaderInterceptor interceptor;
        if (context.getBootstrapContext().isRegistered(ConsulBootstrapper.LoaderInterceptor.class) && (interceptor = (ConsulBootstrapper.LoaderInterceptor)context.getBootstrapContext().get(ConsulBootstrapper.LoaderInterceptor.class)) != null) {
            Binder binder = (Binder)context.getBootstrapContext().get(Binder.class);
            return (ConfigData)interceptor.apply(new ConsulBootstrapper.LoadContext(context, resource, binder, this::doLoad));
        }
        return this.doLoad(context, resource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext context, ConsulConfigDataResource resource) {
        try {
            ConsulClient consul = this.getBean(context, ConsulClient.class);
            ConsulConfigIndexes indexes = this.getBean(context, ConsulConfigIndexes.class);
            ConsulPropertySource propertySource = resource.getConsulPropertySources().createPropertySource(resource.getContext(), consul, indexes.getIndexes()::put);
            if (propertySource == null) {
                return null;
            }
            List<ConsulPropertySource> propertySources = Collections.singletonList(propertySource);
            if (ALL_OPTIONS.size() == 1) {
                return new ConfigData(propertySources, new ConfigData.Option[0]);
            }
            if (ALL_OPTIONS.size() == 2) {
                return new ConfigData(propertySources, new ConfigData.Option[]{ConfigData.Option.IGNORE_IMPORTS, ConfigData.Option.IGNORE_PROFILES});
            }
            if (ALL_OPTIONS.size() > 2) {
                return new ConfigData(propertySources, source -> {
                    ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
                    options.add(ConfigData.Option.IGNORE_IMPORTS);
                    options.add(ConfigData.Option.IGNORE_PROFILES);
                    if (StringUtils.hasText((String)resource.getProfile())) {
                        options.add(ConfigData.Option.PROFILE_SPECIFIC);
                    }
                    return ConfigData.Options.of((ConfigData.Option[])options.toArray(new ConfigData.Option[0]));
                });
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error getting properties from consul: " + (Object)((Object)resource)), (Throwable)e);
            }
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
        return null;
    }

    protected <T> T getBean(ConfigDataLoaderContext context, Class<T> type) {
        if (context.getBootstrapContext().isRegistered(type)) {
            return (T)context.getBootstrapContext().get(type);
        }
        return null;
    }
}

