/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import javax.annotation.PostConstruct;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.consul.discovery.heartbeat")
public class HeartbeatProperties {
    private static final Log log = LogFactory.getLog(HeartbeatProperties.class);
    boolean enabled = false;
    @Min(value=1L)
    private int ttlValue = 30;
    @NotNull
    private String ttlUnit = "s";
    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    private double intervalRatio = 0.6666666666666666;
    private Period heartbeatInterval;

    @PostConstruct
    public void init() {
        this.heartbeatInterval = this.computeHearbeatInterval();
        log.debug((Object)("Computed heartbeatInterval: " + this.heartbeatInterval));
    }

    protected Period computeHearbeatInterval() {
        double interval = (double)this.ttlValue * this.intervalRatio;
        double max = Math.max(interval, 1.0);
        int ttlMinus1 = this.ttlValue - 1;
        double min = Math.min((double)ttlMinus1, max);
        return new Period(Math.round(1000.0 * min));
    }

    public String getTtl() {
        return this.ttlValue + this.ttlUnit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTtlValue() {
        return this.ttlValue;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public double getIntervalRatio() {
        return this.intervalRatio;
    }

    public Period getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTtlValue(int ttlValue) {
        this.ttlValue = ttlValue;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setIntervalRatio(double intervalRatio) {
        this.intervalRatio = intervalRatio;
    }

    public void setHeartbeatInterval(Period heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeartbeatProperties)) {
            return false;
        }
        HeartbeatProperties other = (HeartbeatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getTtlValue() != other.getTtlValue()) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        if (Double.compare(this.getIntervalRatio(), other.getIntervalRatio()) != 0) {
            return false;
        }
        Period this$heartbeatInterval = this.getHeartbeatInterval();
        Period other$heartbeatInterval = other.getHeartbeatInterval();
        return !(this$heartbeatInterval == null ? other$heartbeatInterval != null : !this$heartbeatInterval.equals(other$heartbeatInterval));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeartbeatProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getTtlValue();
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        long $intervalRatio = Double.doubleToLongBits(this.getIntervalRatio());
        result = result * 59 + (int)($intervalRatio >>> 32 ^ $intervalRatio);
        Period $heartbeatInterval = this.getHeartbeatInterval();
        result = result * 59 + ($heartbeatInterval == null ? 43 : $heartbeatInterval.hashCode());
        return result;
    }

    public String toString() {
        return "HeartbeatProperties(enabled=" + this.isEnabled() + ", ttlValue=" + this.getTtlValue() + ", ttlUnit=" + this.getTtlUnit() + ", intervalRatio=" + this.getIntervalRatio() + ", heartbeatInterval=" + this.getHeartbeatInterval() + ")";
    }
}

