/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.ConsulException;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class ConsulLifecycle
extends AbstractDiscoveryLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ConsulLifecycle.class);
    public static final char SEPARATOR = '-';
    private ConsulClient client;
    private ConsulDiscoveryProperties properties;
    private HeartbeatProperties ttlConfig;
    private TtlScheduler ttlScheduler;
    private ServletContext servletContext;
    private NewService service = new NewService();
    private String instanceId;
    private RelaxedPropertyResolver propertyResolver;

    public ConsulLifecycle(ConsulClient client, ConsulDiscoveryProperties properties, HeartbeatProperties ttlConfig) {
        this.client = client;
        this.properties = properties;
        this.ttlConfig = ttlConfig;
    }

    public void setTtlScheduler(TtlScheduler ttlScheduler) {
        this.ttlScheduler = ttlScheduler;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.propertyResolver = new RelaxedPropertyResolver((PropertyResolver)applicationContext.getEnvironment());
    }

    protected int getConfiguredPort() {
        return this.service.getPort() == null ? 0 : this.service.getPort();
    }

    protected void setConfiguredPort(int port) {
        this.service.setPort(Integer.valueOf(port));
    }

    public void setPort(int port) {
        this.getPort().set(port);
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public void start() {
        super.start();
    }

    protected void register() {
        if (!this.properties.isRegister()) {
            log.debug("Registration disabled.");
            return;
        }
        Assert.notNull((Object)this.service.getPort(), (String)"service.port has not been set");
        ConsulAutoRegistration registration = ConsulAutoRegistration.lifecycleRegistration(this.service.getPort(), this.getServiceId(), this.properties, this.getContext(), this.servletContext, this.ttlConfig);
        if (registration.getService().getPort() == null) {
            registration.initializePort(this.service.getPort());
        }
        this.service = registration.getService();
        this.register(this.service);
    }

    @Deprecated
    public String getServiceId() {
        return this.getInstanceId();
    }

    public String getInstanceId() {
        if (this.instanceId == null) {
            this.instanceId = ConsulAutoRegistration.getInstanceId(this.properties, this.getContext());
        }
        return this.instanceId;
    }

    protected void registerManagement() {
        if (!this.properties.isRegister()) {
            return;
        }
        ConsulAutoRegistration registration = ConsulAutoRegistration.managementRegistration(this.properties, this.getContext(), this.ttlConfig);
        this.register(registration.getService());
    }

    protected void register(NewService newService) {
        log.info("Registering service with consul: {}", (Object)newService.toString());
        try {
            this.client.agentServiceRegister(newService, this.properties.getAclToken());
            if (this.ttlConfig.isEnabled() && this.ttlScheduler != null) {
                this.ttlScheduler.add(newService);
            }
        }
        catch (ConsulException e) {
            if (this.properties.isFailFast()) {
                log.error("Error registering service with consul: {}", (Object)newService.toString(), (Object)e);
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            log.warn("Failfast is false. Error registering service with consul: {}", (Object)newService.toString(), (Object)e);
        }
    }

    protected Object getConfiguration() {
        return this.properties;
    }

    protected void deregister() {
        this.deregister(this.getServiceId());
    }

    protected void deregisterManagement() {
        this.deregister(this.getManagementServiceId());
    }

    private void deregister(String serviceId) {
        if (!this.properties.isRegister()) {
            return;
        }
        if (this.ttlScheduler != null) {
            this.ttlScheduler.remove(serviceId);
        }
        log.info("Deregistering service with consul: {}", (Object)serviceId);
        this.client.agentServiceDeregister(serviceId);
    }

    protected boolean isEnabled() {
        return this.properties.getLifecycle().isEnabled();
    }

    protected String getAppName() {
        return ConsulAutoRegistration.getAppName(this.properties, this.propertyResolver);
    }

    public String getManagementServiceId() {
        return ConsulAutoRegistration.normalizeForDns(this.getContext().getId()) + '-' + this.properties.getManagementSuffix();
    }

    public String getManagementServiceName() {
        return ConsulAutoRegistration.normalizeForDns(this.getAppName()) + '-' + this.properties.getManagementSuffix();
    }

    protected Integer getManagementPort() {
        return ConsulAutoRegistration.getManagementPort(this.properties, this.getContext());
    }

    @Deprecated
    public static String normalizeForDns(String s) {
        return ConsulAutoRegistration.normalizeForDns(s);
    }
}

