/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulLifecycle;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TestConsulLifecycleConfiguration {
    @Autowired(required=false)
    private ServerProperties serverProperties;
    @Autowired(required=false)
    private TtlScheduler ttlScheduler;
    @Autowired(required=false)
    private ObjectProvider<ServletContext> servletContext;

    @Bean
    public ConsulLifecycle consulLifecycle(ConsulClient consulClient, ConsulDiscoveryProperties discoveryProperties, HeartbeatProperties heartbeatProperties) {
        ConsulLifecycle lifecycle = new ConsulLifecycle(consulClient, discoveryProperties, heartbeatProperties);
        if (this.ttlScheduler != null) {
            lifecycle.setTtlScheduler(this.ttlScheduler);
        }
        if (this.servletContext != null) {
            lifecycle.setServletContext(this.servletContext);
        }
        if (this.serverProperties != null && this.serverProperties.getPort() != null && this.serverProperties.getPort() > 0) {
            lifecycle.setPort(this.serverProperties.getPort());
        }
        return lifecycle;
    }
}

