/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

class BootstrapPropertySource<T>
extends EnumerablePropertySource<T> {
    private PropertySource<T> p;

    BootstrapPropertySource(PropertySource<T> p) {
        super("bootstrapProperties-" + p.getName(), p.getSource());
        this.p = p;
    }

    public Object getProperty(String name) {
        return this.p.getProperty(name);
    }

    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (!(this.p instanceof EnumerablePropertySource)) {
            throw new IllegalStateException("Failed to enumerate property names due to non-enumerable property source: " + this.p);
        }
        names.addAll(Arrays.asList(((EnumerablePropertySource)this.p).getPropertyNames()));
        return StringUtils.toStringArray(names);
    }
}

