/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.named;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.cloud.context.named.ClientFactoryObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public abstract class NamedContextFactory<C extends Specification>
implements DisposableBean,
ApplicationContextAware {
    private final Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers;
    private final String propertySourceName;
    private final String propertyName;
    private final Map<String, GenericApplicationContext> contexts = new ConcurrentHashMap<String, GenericApplicationContext>();
    private Map<String, C> configurations = new ConcurrentHashMap<String, C>();
    private ApplicationContext parent;
    private Class<?> defaultConfigType;

    public NamedContextFactory(Class<?> defaultConfigType, String propertySourceName, String propertyName) {
        this(defaultConfigType, propertySourceName, propertyName, new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>());
    }

    public NamedContextFactory(Class<?> defaultConfigType, String propertySourceName, String propertyName, Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers) {
        this.defaultConfigType = defaultConfigType;
        this.propertySourceName = propertySourceName;
        this.propertyName = propertyName;
        this.applicationContextInitializers = applicationContextInitializers;
    }

    public void setApplicationContext(ApplicationContext parent) throws BeansException {
        this.parent = parent;
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    public void setConfigurations(List<C> configurations) {
        for (Specification client : configurations) {
            this.configurations.put(client.getName(), client);
        }
    }

    public Set<String> getContextNames() {
        return new HashSet<String>(this.contexts.keySet());
    }

    public void destroy() {
        Collection<GenericApplicationContext> values = this.contexts.values();
        for (GenericApplicationContext context : values) {
            context.close();
        }
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericApplicationContext getContext(String name) {
        if (!this.contexts.containsKey(name)) {
            Map<String, GenericApplicationContext> map = this.contexts;
            synchronized (map) {
                if (!this.contexts.containsKey(name)) {
                    this.contexts.put(name, this.createContext(name));
                }
            }
        }
        return this.contexts.get(name);
    }

    public GenericApplicationContext createContext(String name) {
        GenericApplicationContext context = this.buildContext(name);
        if (this.applicationContextInitializers.get(name) != null) {
            this.applicationContextInitializers.get(name).initialize((ConfigurableApplicationContext)context);
            context.refresh();
            return context;
        }
        this.registerBeans(name, context);
        context.refresh();
        return context;
    }

    public void registerBeans(String name, GenericApplicationContext context) {
        Assert.isInstanceOf(AnnotationConfigRegistry.class, (Object)context);
        AnnotationConfigRegistry registry = (AnnotationConfigRegistry)context;
        if (this.configurations.containsKey(name)) {
            for (Class<?> configuration : ((Specification)this.configurations.get(name)).getConfiguration()) {
                registry.register(new Class[]{configuration});
            }
        }
        for (Map.Entry entry : this.configurations.entrySet()) {
            if (!((String)entry.getKey()).startsWith("default.")) continue;
            for (Class<?> configuration : ((Specification)entry.getValue()).getConfiguration()) {
                registry.register(new Class[]{configuration});
            }
        }
        registry.register(new Class[]{PropertyPlaceholderAutoConfiguration.class, this.defaultConfigType});
    }

    public GenericApplicationContext buildContext(String name) {
        GenericApplicationContext context;
        if (this.parent != null) {
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
            if (this.parent instanceof ConfigurableApplicationContext) {
                beanFactory.setBeanClassLoader(((ConfigurableApplicationContext)this.parent).getBeanFactory().getBeanClassLoader());
            } else {
                beanFactory.setBeanClassLoader(this.parent.getClassLoader());
            }
            context = AotDetector.useGeneratedArtifacts() ? new GenericApplicationContext(beanFactory) : new AnnotationConfigApplicationContext(beanFactory);
            context.setClassLoader(this.parent.getClassLoader());
        } else {
            context = AotDetector.useGeneratedArtifacts() ? new GenericApplicationContext() : new AnnotationConfigApplicationContext();
        }
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource(this.propertySourceName, Collections.singletonMap(this.propertyName, name)));
        if (this.parent != null) {
            context.setParent(this.parent);
        }
        context.setDisplayName(this.generateDisplayName(name));
        return context;
    }

    protected String generateDisplayName(String name) {
        return this.getClass().getSimpleName() + "-" + name;
    }

    public <T> T getInstance(String name, Class<T> type) {
        GenericApplicationContext context = this.getContext(name);
        try {
            return (T)context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    public <T> ObjectProvider<T> getLazyProvider(String name, Class<T> type) {
        return new ClientFactoryObjectProvider<T>(this, name, type);
    }

    public <T> ObjectProvider<T> getProvider(String name, Class<T> type) {
        GenericApplicationContext context = this.getContext(name);
        return context.getBeanProvider(type);
    }

    public <T> T getInstance(String name, Class<?> clazz, Class<?> ... generics) {
        ResolvableType type = ResolvableType.forClassWithGenerics(clazz, (Class[])generics);
        return this.getInstance(name, type);
    }

    public <T> T getInstance(String name, ResolvableType type) {
        GenericApplicationContext context = this.getContext(name);
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, (ResolvableType)type);
        if (beanNames.length > 0) {
            for (String beanName : beanNames) {
                if (!context.isTypeMatch(beanName, type)) continue;
                return (T)context.getBean(beanName);
            }
        }
        return null;
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        GenericApplicationContext context = this.getContext(name);
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, type);
    }

    public Map<String, C> getConfigurations() {
        return this.configurations;
    }

    public static interface Specification {
        public String getName();

        public Class<?>[] getConfiguration();
    }
}

