/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class FunctionalSpringApplication
extends SpringApplication {
    public static final String SPRING_FUNCTIONAL_ENABLED = "spring.functional.enabled";
    public static final String SPRING_WEB_APPLICATION_TYPE = "spring.main.web-application-type";
    private static final String DEFAULT_PROPERTIES = "defaultProperties";

    public FunctionalSpringApplication(Class<?> ... primarySources) {
        super((Class[])primarySources);
        this.setApplicationContextClass(GenericApplicationContext.class);
        if (ClassUtils.isPresent((String)"org.springframework.web.reactive.DispatcherHandler", null)) {
            this.setWebApplicationType(WebApplicationType.REACTIVE);
        } else {
            this.setWebApplicationType(WebApplicationType.NONE);
        }
    }

    public static void main(String[] args) throws Exception {
        FunctionalSpringApplication.run(new Class[0], args);
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return FunctionalSpringApplication.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        return new FunctionalSpringApplication(primarySources).run(args);
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        super.postProcessApplicationContext(context);
        boolean functional = false;
        if (context instanceof GenericApplicationContext) {
            GenericApplicationContext generic = (GenericApplicationContext)context;
            for (Object source : this.getAllSources()) {
                Class type = null;
                Object handler = null;
                if (source instanceof String) {
                    String name = (String)source;
                    if (ClassUtils.isPresent((String)name, null)) {
                        type = ClassUtils.resolveClassName((String)name, null);
                    }
                } else if (source instanceof Class) {
                    type = (Class)source;
                } else {
                    type = source.getClass();
                    handler = source;
                }
                if (type == null) continue;
                if (ApplicationContextInitializer.class.isAssignableFrom(type)) {
                    if (handler == null) {
                        handler = BeanUtils.instantiateClass((Class)type);
                    }
                    ApplicationContextInitializer initializer = (ApplicationContextInitializer)handler;
                    initializer.initialize((ConfigurableApplicationContext)generic);
                    functional = true;
                    continue;
                }
                if (!Function.class.isAssignableFrom(type) && !Consumer.class.isAssignableFrom(type) && !Supplier.class.isAssignableFrom(type)) continue;
                Class functionType = type;
                Object function = handler;
                generic.registerBean("function", FunctionRegistration.class, () -> new FunctionRegistration<Object>(this.handler(generic, function, functionType), new String[0]).type(FunctionType.of(functionType)), new BeanDefinitionCustomizer[0]);
                functional = true;
            }
            if (functional) {
                this.defaultProperties((ConfigurableApplicationContext)generic);
            }
        }
    }

    private Object handler(GenericApplicationContext generic, Object handler, Class<?> type) {
        if (handler == null) {
            handler = generic.getAutowireCapableBeanFactory().createBean(type);
        }
        return handler;
    }

    protected void load(ApplicationContext context, Object[] sources) {
        if (!((Boolean)context.getEnvironment().getProperty(SPRING_FUNCTIONAL_ENABLED, Boolean.class, (Object)false)).booleanValue()) {
            super.load(context, sources);
        }
    }

    private void defaultProperties(ConfigurableApplicationContext context) {
        MutablePropertySources sources = context.getEnvironment().getPropertySources();
        if (!sources.contains(DEFAULT_PROPERTIES)) {
            sources.addLast((PropertySource)new MapPropertySource(DEFAULT_PROPERTIES, Collections.emptyMap()));
        }
        Map source = (Map)sources.get(DEFAULT_PROPERTIES).getSource();
        HashMap<String, String> map = new HashMap<String, String>(source);
        map.put(SPRING_FUNCTIONAL_ENABLED, "true");
        map.put(SPRING_WEB_APPLICATION_TYPE, (String)this.getWebApplicationType());
        sources.replace(DEFAULT_PROPERTIES, (PropertySource)new MapPropertySource(DEFAULT_PROPERTIES, map));
    }
}

