/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSpringFunctionAdapterInitializer<C>
implements Closeable {
    private static Log logger = LogFactory.getLog(AbstractSpringFunctionAdapterInitializer.class);
    public static final String TARGET_EXECUTION_CTX_BEAN_NAME = "targetExecutionContext";
    private final Class<?> configurationClass;
    private Function<Publisher<?>, Publisher<?>> function;
    private Consumer<Publisher<?>> consumer;
    private Supplier<Publisher<?>> supplier;
    private FunctionRegistration<?> functionRegistration;
    private AtomicBoolean initialized = new AtomicBoolean();
    @Autowired(required=false)
    private FunctionInspector inspector;
    @Autowired(required=false)
    private FunctionCatalog catalog;
    private ConfigurableApplicationContext context;

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public AbstractSpringFunctionAdapterInitializer(Class<?> configurationClass) {
        Assert.notNull(configurationClass, (String)"'configurationClass' must not be null");
        this.configurationClass = configurationClass;
    }

    public AbstractSpringFunctionAdapterInitializer() {
        this(FunctionClassUtils.getStartClass());
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void initialize(C targetContext) {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        logger.info((Object)("Initializing: " + this.configurationClass));
        SpringApplication builder = this.springApplication();
        this.registerTargetContext(targetContext, builder);
        ConfigurableApplicationContext context = builder.run(new String[0]);
        context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        this.context = context;
        if (this.catalog == null) {
            this.initFunctionConsumerOrSupplierFromContext(targetContext);
        } else {
            this.initFunctionConsumerOrSupplierFromCatalog(targetContext);
        }
    }

    private void registerTargetContext(final C targetContext, SpringApplication builder) {
        if (targetContext != null) {
            builder.addInitializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<ConfigurableApplicationContext>(){

                public void initialize(ConfigurableApplicationContext applicationContext) {
                    ((GenericApplicationContext)applicationContext).registerBean(AbstractSpringFunctionAdapterInitializer.TARGET_EXECUTION_CTX_BEAN_NAME, targetContext.getClass(), () -> targetContext, new BeanDefinitionCustomizer[0]);
                }
            }});
        }
    }

    protected FunctionInspector getInspector() {
        return this.inspector;
    }

    protected Class<?> getInputType() {
        if (this.inspector != null) {
            return this.inspector.getInputType(this.function());
        }
        if (this.functionRegistration != null) {
            return this.functionRegistration.getType().getInputType();
        }
        return Object.class;
    }

    protected Function<Publisher<?>, Publisher<?>> getFunction() {
        return this.function;
    }

    protected Object function() {
        if (this.function != null) {
            return this.function;
        }
        if (this.consumer != null) {
            return this.consumer;
        }
        if (this.supplier != null) {
            return this.supplier;
        }
        return null;
    }

    protected Publisher<?> apply(Publisher<?> input) {
        if (this.function != null) {
            return Flux.from(this.function.apply(input));
        }
        if (this.consumer != null) {
            this.consumer.accept(input);
            return Flux.empty();
        }
        if (this.supplier != null) {
            Mono result = this.supplier.get();
            if (!(result instanceof Publisher)) {
                result = Mono.just(result);
            }
            return result;
        }
        throw new IllegalStateException("No function defined");
    }

    protected String doResolveName(Object targetContext) {
        return "";
    }

    protected Object convertOutput(Object input, Object output) {
        return output;
    }

    protected <O> O result(Object input, Publisher<?> output) {
        Object value;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value2 : Flux.from(output).toIterable()) {
            result.add(this.convertOutput(input, value2));
        }
        if (this.isSingleInput(this.getFunction(), input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        if (this.isSingleOutput(this.getFunction(), input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        value = result;
        return CollectionUtils.isEmpty(result) ? null : (O)value;
    }

    private boolean isSingleInput(Function<?, ?> function, Object input) {
        if (!(input instanceof Collection)) {
            return true;
        }
        if (this.getInspector() != null) {
            return Collection.class.isAssignableFrom(this.getInspector().getInputType(function));
        }
        return ((Collection)input).size() <= 1;
    }

    private boolean isSingleOutput(Function<?, ?> function, Object output) {
        if (!(output instanceof Collection)) {
            return true;
        }
        if (this.getInspector() != null) {
            return Collection.class.isAssignableFrom(this.getInspector().getOutputType(function));
        }
        return ((Collection)output).size() <= 1;
    }

    private String resolveName(Class<?> type, Object targetContext) {
        String functionName = this.context.getEnvironment().getProperty("function.name");
        if (functionName != null) {
            return functionName;
        }
        if (type.isAssignableFrom(Function.class)) {
            return "function";
        }
        if (type.isAssignableFrom(Consumer.class)) {
            return "consumer";
        }
        if (type.isAssignableFrom(Supplier.class)) {
            return "supplier";
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private <T> T getAndInstrumentFromContext(String name) {
        this.functionRegistration = new FunctionRegistration<Object>(this.context.getBean(name), name);
        Type type = FunctionContextUtils.findType(name, this.context.getBeanFactory());
        this.functionRegistration = this.functionRegistration.type(new FunctionType(type)).wrap();
        return (T)this.functionRegistration.getTarget();
    }

    private void initFunctionConsumerOrSupplierFromContext(Object targetContext) {
        String name = this.resolveName(Function.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Function) {
            this.function = (Function)this.getAndInstrumentFromContext(name);
            return;
        }
        name = this.resolveName(Consumer.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Consumer) {
            this.function = (Function)this.getAndInstrumentFromContext(name);
            return;
        }
        name = this.resolveName(Supplier.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Supplier) {
            this.supplier = (Supplier)this.getAndInstrumentFromContext(name);
            return;
        }
    }

    private void initFunctionConsumerOrSupplierFromCatalog(Object targetContext) {
        String name = this.resolveName(Function.class, targetContext);
        this.function = (Function)this.catalog.lookup(Function.class, name);
        if (this.function != null) {
            return;
        }
        name = this.resolveName(Consumer.class, targetContext);
        this.consumer = (Consumer)this.catalog.lookup(Consumer.class, name);
        if (this.consumer != null) {
            return;
        }
        name = this.resolveName(Supplier.class, targetContext);
        this.supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
        if (this.supplier != null) {
            return;
        }
        if (this.catalog.size() >= 1 && this.catalog.size() <= 2) {
            String functionName = this.catalog.getNames(Function.class).stream().filter(n -> !n.equals("functionRouter")).findFirst().orElseGet(() -> null);
            if (functionName != null) {
                this.function = (Function)this.catalog.lookup(Function.class, functionName);
                return;
            }
            functionName = this.catalog.getNames(Supplier.class).stream().findFirst().orElseGet(() -> null);
            if (functionName != null) {
                this.supplier = (Supplier)this.catalog.lookup(Supplier.class, functionName);
                return;
            }
        } else {
            name = this.doResolveName(targetContext);
            this.function = (Function)this.catalog.lookup(Function.class, name);
            if (this.function != null) {
                return;
            }
            this.consumer = (Consumer)this.catalog.lookup(Consumer.class, name);
            if (this.consumer != null) {
                return;
            }
            this.supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
            if (this.supplier != null) {
                return;
            }
        }
    }

    private SpringApplication springApplication() {
        Class<?> sourceClass = this.configurationClass;
        FunctionalSpringApplication application = new FunctionalSpringApplication(sourceClass);
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }
}

