/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.json.JsonMapper;

public class JacksonMapper
extends JsonMapper {
    private static Log logger = LogFactory.getLog(JacksonMapper.class);
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void configureObjectMapper(Consumer<ObjectMapper> configurer) {
        configurer.accept(this.mapper);
    }

    @Override
    protected <T> T doFromJson(Object json, Type type) {
        Object convertedValue = null;
        JavaType constructType = TypeFactory.defaultInstance().constructType(type);
        try {
            if (json instanceof String) {
                convertedValue = this.mapper.readValue((String)json, constructType);
            } else if (json instanceof byte[]) {
                convertedValue = this.mapper.readValue((byte[])json, constructType);
            } else if (json instanceof Reader) {
                convertedValue = this.mapper.readValue((Reader)json, constructType);
            } else if (json instanceof Map) {
                convertedValue = this.mapper.convertValue(json, constructType);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert. Possible bug as the conversion probably shouldn't have been attempted here", e);
        }
        return (T)convertedValue;
    }

    @Override
    public byte[] toJson(Object value) {
        byte[] jsonBytes;
        block3: {
            jsonBytes = super.toJson(value);
            if (jsonBytes == null) {
                try {
                    jsonBytes = this.mapper.writeValueAsBytes(value);
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace((Object)("Failed to writeValueAsBytes: " + value), (Throwable)e);
                }
            }
        }
        return jsonBytes;
    }

    @Override
    public String toString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot convert to JSON", e);
        }
    }
}

