/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.springframework.core.convert.converter.Converter;

public class StringToZonedDateTimeConverter
implements Converter<String, ZonedDateTime> {
    public ZonedDateTime convert(String source) {
        ZonedDateTime dateTime;
        try {
            long epoch = Long.parseLong(source);
            dateTime = Instant.ofEpochMilli(epoch).atOffset(ZoneOffset.ofTotalSeconds(0)).toZonedDateTime();
        }
        catch (NumberFormatException e) {
            dateTime = ZonedDateTime.parse(source);
        }
        return dateTime;
    }
}

