/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectToGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String STATUS_KEY = "status";
    public static final String URL_KEY = "url";

    public RedirectToGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(STATUS_KEY, URL_KEY);
    }

    @Override
    public GatewayFilter apply(Config config) {
        return this.apply(config.status, config.url);
    }

    @Override
    public GatewayFilter apply(String statusString, String urlString) {
        HttpStatusHolder httpStatus = HttpStatusHolder.parse(statusString);
        Assert.isTrue((boolean)httpStatus.is3xxRedirection(), (String)("status must be a 3xx code, but was " + statusString));
        URI url = URI.create(urlString);
        return this.apply(httpStatus, url);
    }

    public GatewayFilter apply(HttpStatus httpStatus, URI uri) {
        return this.apply(new HttpStatusHolder(httpStatus, null), uri);
    }

    public GatewayFilter apply(final HttpStatusHolder httpStatus, final URI uri) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                if (!exchange.getResponse().isCommitted()) {
                    ServerWebExchangeUtils.setResponseStatus(exchange, httpStatus);
                    ServerHttpResponse response = exchange.getResponse();
                    response.getHeaders().set("Location", uri.toString());
                    return response.setComplete();
                }
                return Mono.empty();
            }

            public String toString() {
                String status = httpStatus.getHttpStatus() != null ? String.valueOf(httpStatus.getHttpStatus().value()) : httpStatus.getStatus().toString();
                return GatewayToStringStyler.filterToStringCreator(RedirectToGatewayFilterFactory.this).append(status, (Object)uri).toString();
            }
        };
    }

    public static class Config {
        String status;
        String url;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

