/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BeforeRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CloudFoundryRouteServiceRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CookieRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HeaderRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.MethodRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.QueryRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.ReadBodyRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.WeightRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.builder.BooleanSpec;
import org.springframework.cloud.gateway.route.builder.GatewayFilterSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.route.builder.UriSpec;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ipresolver.RemoteAddressResolver;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;

public class PredicateSpec
extends UriSpec {
    PredicateSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder) {
        super(routeBuilder, builder);
    }

    public PredicateSpec order(int order) {
        this.routeBuilder.order(order);
        return this;
    }

    public BooleanSpec predicate(Predicate<ServerWebExchange> predicate) {
        return this.asyncPredicate(ServerWebExchangeUtils.toAsyncPredicate(predicate));
    }

    public BooleanSpec asyncPredicate(AsyncPredicate<ServerWebExchange> predicate) {
        this.routeBuilder.asyncPredicate(predicate);
        return new BooleanSpec(this.routeBuilder, this.builder);
    }

    protected GatewayFilterSpec createGatewayFilterSpec() {
        return new GatewayFilterSpec(this.routeBuilder, this.builder);
    }

    public BooleanSpec after(ZonedDateTime datetime) {
        return this.asyncPredicate(this.getBean(AfterRoutePredicateFactory.class).applyAsync(c -> c.setDatetime(datetime)));
    }

    public BooleanSpec before(ZonedDateTime datetime) {
        return this.asyncPredicate(this.getBean(BeforeRoutePredicateFactory.class).applyAsync(c -> c.setDatetime(datetime)));
    }

    public BooleanSpec between(ZonedDateTime datetime1, ZonedDateTime datetime2) {
        return this.asyncPredicate(this.getBean(BetweenRoutePredicateFactory.class).applyAsync(c -> c.setDatetime1(datetime1).setDatetime2(datetime2)));
    }

    public BooleanSpec cookie(String name, String regex) {
        return this.asyncPredicate(this.getBean(CookieRoutePredicateFactory.class).applyAsync(c -> c.setName(name).setRegexp(regex)));
    }

    public BooleanSpec header(String header) {
        return this.asyncPredicate(this.getBean(HeaderRoutePredicateFactory.class).applyAsync(c -> c.setHeader(header)));
    }

    public BooleanSpec header(String header, String regex) {
        return this.asyncPredicate(this.getBean(HeaderRoutePredicateFactory.class).applyAsync(c -> c.setHeader(header).setRegexp(regex)));
    }

    public BooleanSpec host(String ... pattern) {
        return this.asyncPredicate(this.getBean(HostRoutePredicateFactory.class).applyAsync(c -> c.setPatterns(Arrays.asList(pattern))));
    }

    public BooleanSpec method(String ... methods) {
        return this.asyncPredicate(this.getBean(MethodRoutePredicateFactory.class).applyAsync(c -> {
            HttpMethod[] httpMethods = (HttpMethod[])Arrays.stream(methods).map(HttpMethod::resolve).toArray(HttpMethod[]::new);
            c.setMethods(httpMethods);
        }));
    }

    public BooleanSpec method(HttpMethod ... methods) {
        return this.asyncPredicate(this.getBean(MethodRoutePredicateFactory.class).applyAsync(c -> c.setMethods(methods)));
    }

    public BooleanSpec path(String ... patterns) {
        return this.asyncPredicate(this.getBean(PathRoutePredicateFactory.class).applyAsync(c -> c.setPatterns(Arrays.asList(patterns))));
    }

    public BooleanSpec path(boolean matchTrailingSlash, String ... patterns) {
        return this.asyncPredicate(this.getBean(PathRoutePredicateFactory.class).applyAsync(c -> c.setPatterns(Arrays.asList(patterns)).setMatchTrailingSlash(matchTrailingSlash)));
    }

    public <T> BooleanSpec readBody(Class<T> inClass, Predicate<T> predicate) {
        return this.asyncPredicate(this.getBean(ReadBodyRoutePredicateFactory.class).applyAsync(c -> c.setPredicate(inClass, predicate)));
    }

    public BooleanSpec query(String param, String regex) {
        return this.asyncPredicate(this.getBean(QueryRoutePredicateFactory.class).applyAsync(c -> c.setParam(param).setRegexp(regex)));
    }

    public BooleanSpec query(String param) {
        return this.asyncPredicate(this.getBean(QueryRoutePredicateFactory.class).applyAsync(c -> c.setParam(param)));
    }

    public BooleanSpec remoteAddr(String ... addrs) {
        return this.remoteAddr((RemoteAddressResolver)null, addrs);
    }

    public BooleanSpec remoteAddr(RemoteAddressResolver resolver, String ... addrs) {
        return this.asyncPredicate(this.getBean(RemoteAddrRoutePredicateFactory.class).applyAsync(c -> {
            c.setSources(addrs);
            if (resolver != null) {
                c.setRemoteAddressResolver(resolver);
            }
        }));
    }

    public BooleanSpec weight(String group, int weight) {
        return this.asyncPredicate(this.getBean(WeightRoutePredicateFactory.class).applyAsync(c -> c.setGroup(group).setRouteId(this.routeBuilder.getId()).setWeight(weight)));
    }

    public BooleanSpec cloudFoundryRouteService() {
        return this.predicate(this.getBean(CloudFoundryRouteServiceRoutePredicateFactory.class).apply(c -> {}));
    }

    public BooleanSpec alwaysTrue() {
        return this.predicate(exchange -> true);
    }

    public BooleanSpec not(Function<PredicateSpec, BooleanSpec> fn) {
        return this.alwaysTrue().and().not(fn);
    }
}

