/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.cloud.gateway.config.AbstractSslConfigurer;
import org.springframework.cloud.gateway.config.HttpClientProperties;

public class GrpcSslConfigurer
extends AbstractSslConfigurer<NettyChannelBuilder, ManagedChannel> {
    public GrpcSslConfigurer(HttpClientProperties.Ssl sslProperties, SslBundles bundles) {
        super(sslProperties, bundles);
    }

    @Override
    public ManagedChannel configureSsl(NettyChannelBuilder NettyChannelBuilder2) throws SSLException {
        return NettyChannelBuilder2.useTransportSecurity().sslContext(this.getSslContext()).build();
    }

    private SslContext getSslContext() throws SSLException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
        HttpClientProperties.Ssl ssl = this.getSslProperties();
        boolean useInsecureTrustManager = ssl.isUseInsecureTrustManager();
        SslBundle bundle = this.getBundle();
        if (useInsecureTrustManager) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE.getTrustManagers()[0]);
        }
        if (!useInsecureTrustManager && ssl.getTrustedX509Certificates().size() > 0) {
            sslContextBuilder.trustManager(this.getTrustedX509CertificatesForTrustManager());
        } else if (bundle != null) {
            sslContextBuilder.trustManager(bundle.getManagers().getTrustManagerFactory());
        }
        if (bundle != null) {
            sslContextBuilder.keyManager(bundle.getManagers().getKeyManagerFactory());
        } else {
            sslContextBuilder.keyManager(this.getKeyManagerFactory());
        }
        return sslContextBuilder.build();
    }
}

