/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.reactive.HttpHandlerAutoConfiguration;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogAutoConfiguration;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledGlobalFilter;
import org.springframework.cloud.gateway.filter.FunctionRoutingFilter;
import org.springframework.cloud.gateway.filter.factory.rewrite.MessageBodyEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={ContextFunctionCatalogAutoConfiguration.class})
@AutoConfigureBefore(value={HttpHandlerAutoConfiguration.class, GatewayAutoConfiguration.class})
@ConditionalOnClass(value={FunctionCatalog.class, DispatcherHandler.class})
@ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.function.enabled"}, matchIfMissing=true)
class GatewayFunctionAutoConfiguration {
    GatewayFunctionAutoConfiguration() {
    }

    @Bean
    @ConditionalOnEnabledGlobalFilter
    @ConditionalOnBean(value={FunctionCatalog.class})
    public FunctionRoutingFilter functionRoutingFilter(FunctionCatalog functionCatalog, ServerCodecConfigurer codecConfigurer, Set<MessageBodyEncoder> messageBodyEncoders) {
        return new FunctionRoutingFilter(functionCatalog, codecConfigurer.getReaders(), messageBodyEncoders);
    }
}

