/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.cors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.event.RefreshRoutesResultEvent;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationListener;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.server.ServerWebExchange;

public class CorsGatewayFilterApplicationListener
implements ApplicationListener<RefreshRoutesResultEvent> {
    private final GlobalCorsProperties globalCorsProperties;
    private final RoutePredicateHandlerMapping routePredicateHandlerMapping;
    private final RouteLocator routeLocator;
    private static final String METADATA_KEY = "cors";
    private static final String ALL_PATHS = "/**";

    public CorsGatewayFilterApplicationListener(GlobalCorsProperties globalCorsProperties, RoutePredicateHandlerMapping routePredicateHandlerMapping, RouteLocator routeLocator) {
        this.globalCorsProperties = globalCorsProperties;
        this.routePredicateHandlerMapping = routePredicateHandlerMapping;
        this.routeLocator = routeLocator;
    }

    public void onApplicationEvent(RefreshRoutesResultEvent event) {
        this.routeLocator.getRoutes().collectList().subscribe(routes -> {
            HashMap<String, CorsConfiguration> corsConfigurations = new HashMap<String, CorsConfiguration>(this.globalCorsProperties.getCorsConfigurations());
            routes.forEach(route -> {
                Optional<CorsConfiguration> corsConfiguration = this.getCorsConfiguration((Route)route);
                corsConfiguration.ifPresent(configuration -> {
                    String pathPredicate = this.getPathPredicate((Route)route);
                    corsConfigurations.put(pathPredicate, (CorsConfiguration)configuration);
                });
            });
            this.routePredicateHandlerMapping.setCorsConfigurations(corsConfigurations);
        });
    }

    private String getPathPredicate(Route route) {
        AsyncPredicate<ServerWebExchange> predicate = route.getPredicate();
        AtomicReference pathPatterns = new AtomicReference();
        predicate.accept(p -> {
            PathRoutePredicateFactory.Config pathConfig;
            Object patt3447$temp = p.getConfig();
            if (patt3447$temp instanceof PathRoutePredicateFactory.Config && !(pathConfig = (PathRoutePredicateFactory.Config)patt3447$temp).getPatterns().isEmpty()) {
                pathPatterns.compareAndSet(null, pathConfig.getPatterns().get(0));
            }
        });
        if (pathPatterns.get() != null) {
            return (String)pathPatterns.get();
        }
        return ALL_PATHS;
    }

    private Optional<CorsConfiguration> getCorsConfiguration(Route route) {
        Map corsMetadata = (Map)route.getMetadata().get(METADATA_KEY);
        if (corsMetadata != null) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            this.findValue(corsMetadata, "allowCredentials").ifPresent(value -> corsConfiguration.setAllowCredentials((Boolean)value));
            this.findValue(corsMetadata, "allowedHeaders").ifPresent(value -> corsConfiguration.setAllowedHeaders(this.asList(value)));
            this.findValue(corsMetadata, "allowedMethods").ifPresent(value -> corsConfiguration.setAllowedMethods(this.asList(value)));
            this.findValue(corsMetadata, "allowedOriginPatterns").ifPresent(value -> corsConfiguration.setAllowedOriginPatterns(this.asList(value)));
            this.findValue(corsMetadata, "allowedOrigins").ifPresent(value -> corsConfiguration.setAllowedOrigins(this.asList(value)));
            this.findValue(corsMetadata, "exposedHeaders").ifPresent(value -> corsConfiguration.setExposedHeaders(this.asList(value)));
            this.findValue(corsMetadata, "maxAge").ifPresent(value -> corsConfiguration.setMaxAge(this.asLong(value)));
            return Optional.of(corsConfiguration);
        }
        return Optional.empty();
    }

    private Optional<Object> findValue(Map<String, Object> metadata, String key) {
        Object value = metadata.get(key);
        return Optional.ofNullable(value);
    }

    private List<String> asList(Object value) {
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof Map) {
            return new ArrayList<String>(((Map)value).values());
        }
        return (List)value;
    }

    private Long asLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return (Long)value;
    }
}

