/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigOrSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.RetryProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.policy.NeverRetryPolicy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@EnableConfigurationProperties(value={ConfigMapConfigProperties.class, SecretsConfigProperties.class})
public class KubernetesBootstrapConfiguration {

    @ConditionalOnKubernetesConfigOrSecretsRetryEnabled
    @ConditionalOnClass(value={Retryable.class, Aspect.class, AopAutoConfiguration.class})
    @Configuration(proxyBeanMethods=false)
    @EnableRetry(proxyTargetClass=true)
    @Import(value={AopAutoConfiguration.class})
    public static class RetryConfiguration {
        public static RetryOperationsInterceptor retryOperationsInterceptor(RetryProperties retryProperties) {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(retryProperties.initialInterval(), retryProperties.multiplier(), retryProperties.maxInterval()).maxAttempts(retryProperties.maxAttempts()).build();
        }

        @Bean
        @ConditionalOnKubernetesConfigRetryEnabled
        public RetryOperationsInterceptor kubernetesConfigRetryInterceptor(ConfigMapConfigProperties configProperties) {
            return RetryConfiguration.retryOperationsInterceptor(configProperties.retry());
        }

        @Bean(value={"kubernetesConfigRetryInterceptor"})
        @ConditionalOnKubernetesConfigRetryDisabled
        public RetryOperationsInterceptor kubernetesConfigRetryInterceptorNoRetry() {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().retryPolicy((RetryPolicy)new NeverRetryPolicy()).build();
        }

        @Bean
        @ConditionalOnKubernetesSecretsRetryEnabled
        public RetryOperationsInterceptor kubernetesSecretsRetryInterceptor(SecretsConfigProperties configProperties) {
            return RetryConfiguration.retryOperationsInterceptor(configProperties.retry());
        }

        @Bean(value={"kubernetesSecretsRetryInterceptor"})
        @ConditionalOnKubernetesSecretsRetryDisabled
        public RetryOperationsInterceptor kubernetesSecretsRetryInterceptorNoRetry() {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().retryPolicy((RetryPolicy)new NeverRetryPolicy()).build();
        }
    }
}

