/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    protected ConfigurableEnvironment environment;
    protected ConfigReloadProperties properties;
    protected KubernetesClient kubernetesClient;
    protected ConfigurationUpdateStrategy strategy;

    public ConfigurationChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy) {
        this.environment = environment;
        this.properties = properties;
        this.kubernetesClient = kubernetesClient;
        this.strategy = strategy;
    }

    @PreDestroy
    public void shutdown() {
        this.kubernetesClient.close();
    }

    public void reloadProperties() {
        this.log.info((Object)("Reloading using strategy: " + this.strategy.getName()));
        this.strategy.reload();
    }

    protected boolean changed(MapPropertySource mp1, MapPropertySource mp2) {
        if (mp1 == mp2) {
            return false;
        }
        if (mp1 == null && mp2 != null || mp1 != null && mp2 == null) {
            return true;
        }
        Map s1 = (Map)mp1.getSource();
        Map s2 = (Map)mp2.getSource();
        return s1 == null ? s2 != null : !s1.equals(s2);
    }

    protected boolean changed(List<? extends MapPropertySource> l1, List<? extends MapPropertySource> l2) {
        if (l1.size() != l2.size()) {
            this.log.warn((Object)"The current number of Confimap PropertySources does not match the ones loaded from the Kubernetes - No reload will take place");
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (!this.changed(l1.get(i), l2.get(i))) continue;
            return true;
        }
        return false;
    }

    protected <S extends PropertySource<?>> S findPropertySource(Class<S> sourceClass) {
        List<S> sources = this.findPropertySources(sourceClass);
        if (sources.size() == 0) {
            return null;
        }
        if (sources.size() > 1) {
            this.log.warn((Object)("Found more than one property source of type " + sourceClass));
        }
        return (S)((PropertySource)sources.get(0));
    }

    protected <S extends PropertySource<?>> List<S> findPropertySources(Class<S> sourceClass) {
        LinkedList<S> managedSources = new LinkedList<S>();
        LinkedList<PropertySource> sources = this.toLinkedList((Iterable)this.environment.getPropertySources());
        while (!sources.isEmpty()) {
            PropertySource propertySource;
            PropertySource source = (PropertySource)sources.pop();
            if (source instanceof CompositePropertySource) {
                CompositePropertySource comp = (CompositePropertySource)source;
                sources.addAll(comp.getPropertySources());
                continue;
            }
            if (sourceClass.isInstance(source)) {
                managedSources.add(sourceClass.cast(source));
                continue;
            }
            if (!BootstrapPropertySource.class.isInstance(source) || !sourceClass.isInstance(propertySource = ((BootstrapPropertySource)source).getDelegate())) continue;
            sources.add(propertySource);
        }
        return managedSources;
    }

    private <E> LinkedList<E> toLinkedList(Iterable<E> it) {
        LinkedList<E> list = new LinkedList<E>();
        for (E e : it) {
            list.add(e);
        }
        return list;
    }

    protected List<MapPropertySource> locateMapPropertySources(PropertySourceLocator propertySourceLocator, Environment environment) {
        ArrayList<MapPropertySource> result = new ArrayList<MapPropertySource>();
        PropertySource propertySource = propertySourceLocator.locate(environment);
        if (propertySource instanceof MapPropertySource) {
            result.add((MapPropertySource)propertySource);
        } else if (propertySource instanceof CompositePropertySource) {
            result.addAll(((CompositePropertySource)propertySource).getPropertySources().stream().filter(p -> p instanceof MapPropertySource).map(p -> (MapPropertySource)p).collect(Collectors.toList()));
        } else {
            this.log.debug((Object)("Found property source that cannot be handled: " + propertySource.getClass()));
        }
        return result;
    }
}

