/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.localconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.springframework.cloud.AbstractCloudConnector;
import org.springframework.cloud.FallbackServiceInfoCreator;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.app.BasicApplicationInstanceInfo;
import org.springframework.cloud.localconfig.LocalConfigServiceInfoCreator;
import org.springframework.cloud.localconfig.LocalConfigUtil;
import org.springframework.cloud.localconfig.PropertiesFileResolver;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.FallbackBaseServiceInfoCreator;
import org.springframework.cloud.service.UriBasedServiceData;
import org.springframework.cloud.util.EnvironmentAccessor;

public class LocalConfigConnector
extends AbstractCloudConnector<UriBasedServiceData> {
    private static final Logger logger = Logger.getLogger(LocalConfigConnector.class.getName());
    public static final String PROPERTY_PREFIX = "spring.cloud.";
    public static final Pattern SERVICE_PROPERTY_PATTERN = Pattern.compile("\\A" + Pattern.quote("spring.cloud.") + "(.+)\\Z");
    public static final String APP_ID_PROPERTY = "spring.cloud.appId";
    public static final String PROPERTIES_FILE_PROPERTY = "spring.cloud.propertiesFile";
    public static final List<String> META_PROPERTIES = Collections.unmodifiableList(Arrays.asList("spring.cloud.appId", "spring.cloud.propertiesFile"));
    private EnvironmentAccessor env = new EnvironmentAccessor();
    private Properties fileProperties = null;

    void setEnvironmentAccessor(EnvironmentAccessor env) {
        this.env = env;
    }

    public LocalConfigConnector() {
        super(LocalConfigServiceInfoCreator.class);
    }

    public boolean isInMatchingCloud() {
        String appId;
        if (this.fileProperties == null) {
            this.readFileProperties();
        }
        if ((appId = this.findProperty(APP_ID_PROPERTY)) == null) {
            logger.info("the property spring.cloud.appId was not found in the system properties or configuration file");
        }
        return appId != null;
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        return new BasicApplicationInstanceInfo(UUID.randomUUID().toString(), this.findProperty(APP_ID_PROPERTY), Collections.emptyMap());
    }

    protected List<UriBasedServiceData> getServicesData() {
        if (this.fileProperties == null) {
            throw new IllegalStateException("isInMatchingCloud() must be called first to initialize connector");
        }
        LinkedHashMap<String, Properties> propertySources = new LinkedHashMap<String, Properties>();
        propertySources.put("properties from file", this.fileProperties);
        try {
            propertySources.put("system properties", this.env.getSystemProperties());
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "couldn't read system properties; no service definitions from system properties will be applied", e);
        }
        return LocalConfigUtil.readServicesData(propertySources);
    }

    protected FallbackServiceInfoCreator<BaseServiceInfo, UriBasedServiceData> getFallbackServiceInfoCreator() {
        return new FallbackBaseServiceInfoCreator();
    }

    private void readFileProperties() {
        this.fileProperties = new Properties();
        logger.fine("looking for a properties file");
        File propertiesFile = new PropertiesFileResolver(this.env).findCloudPropertiesFile();
        if (propertiesFile == null) {
            logger.info("not loading service definitions from a properties file");
            return;
        }
        if (!this.fileExists(propertiesFile)) {
            logger.info("properties file " + propertiesFile + " does not exist; probably running in a real cloud");
            return;
        }
        logger.info("loading service definitions from properties file " + propertiesFile);
        try {
            InputStream fis = this.openFile(propertiesFile);
            this.fileProperties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "exception while loading properties from file " + propertiesFile, e);
            return;
        }
        logger.info("properties loaded successfully");
    }

    boolean fileExists(File file) {
        return file.exists();
    }

    InputStream openFile(File file) throws IOException {
        return new FileInputStream(file);
    }

    private String findProperty(String key) {
        String value = this.fileProperties.getProperty(key);
        try {
            value = this.env.getSystemProperty(key, value);
        }
        catch (SecurityException e) {
            LocalConfigConnector.logSystemReadException(key, e);
        }
        return value;
    }

    private static void logSystemReadException(String key, SecurityException e) {
        logger.log(Level.WARNING, "couldn't read system property " + key, e);
    }
}

