/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.stream;

import com.netflix.turbine.aggregator.InstanceKey;
import com.netflix.turbine.aggregator.StreamAggregator;
import com.netflix.turbine.internal.JsonUtility;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.subjects.PublishSubject;

@RestController
public class TurbineController {
    private static final Log log = LogFactory.getLog(TurbineController.class);
    private final Flux<String> flux;

    public TurbineController(PublishSubject<Map<String, Object>> hystrixSubject) {
        Observable stream = StreamAggregator.aggregateGroupedStreams((Observable)hystrixSubject.groupBy(data -> InstanceKey.create((String)((String)data.get("instanceId"))))).doOnUnsubscribe(() -> log.info((Object)"Unsubscribing aggregation.")).doOnSubscribe(() -> log.info((Object)"Starting aggregation")).flatMap(o -> o);
        Flux ping = Flux.interval((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(10L)).map(l -> Collections.singletonMap("type", "ping")).share();
        this.flux = Flux.merge((Publisher[])new Publisher[]{RxReactiveStreams.toPublisher((Observable)stream), ping}).share().map(map -> JsonUtility.mapToJson((Map)map));
    }

    @GetMapping(produces={"text/event-stream"})
    public Flux<String> stream() {
        return this.flux;
    }
}

