/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.discovery;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.netflix.zuul.filters.discovery.ServiceRouteMapper;
import org.springframework.util.StringUtils;

public class PatternServiceRouteMapper
implements ServiceRouteMapper {
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("/{2,}");
    private Pattern servicePattern;
    private String routePattern;

    public PatternServiceRouteMapper(String servicePattern, String routePattern) {
        this.servicePattern = Pattern.compile(servicePattern);
        this.routePattern = routePattern;
    }

    @Override
    public String apply(String serviceId) {
        Matcher matcher = this.servicePattern.matcher(serviceId);
        String route = matcher.replaceFirst(this.routePattern);
        return StringUtils.hasText((String)(route = this.cleanRoute(route))) ? route : serviceId;
    }

    private String cleanRoute(String route) {
        String routeToClean = MULTIPLE_SLASH_PATTERN.matcher(route).replaceAll("/");
        if (routeToClean.startsWith("/")) {
            routeToClean = routeToClean.substring(1);
        }
        if (routeToClean.endsWith("/")) {
            routeToClean = routeToClean.substring(0, routeToClean.length() - 1);
        }
        return routeToClean;
    }
}

