/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.monitoring.CounterFactory;
import com.netflix.zuul.monitoring.TracerFactory;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class ZuulFilterInitializer {
    private static final Log log = LogFactory.getLog(ZuulFilterInitializer.class);
    private final Map<String, ZuulFilter> filters;
    private final CounterFactory counterFactory;
    private final TracerFactory tracerFactory;
    private final FilterLoader filterLoader;
    private final FilterRegistry filterRegistry;

    public ZuulFilterInitializer(Map<String, ZuulFilter> filters, CounterFactory counterFactory, TracerFactory tracerFactory, FilterLoader filterLoader, FilterRegistry filterRegistry) {
        this.filters = filters;
        this.counterFactory = counterFactory;
        this.tracerFactory = tracerFactory;
        this.filterLoader = filterLoader;
        this.filterRegistry = filterRegistry;
    }

    @PostConstruct
    public void contextInitialized() {
        log.info((Object)"Starting filter initializer");
        TracerFactory.initialize((TracerFactory)this.tracerFactory);
        CounterFactory.initialize((CounterFactory)this.counterFactory);
        for (Map.Entry<String, ZuulFilter> entry : this.filters.entrySet()) {
            this.filterRegistry.put(entry.getKey(), entry.getValue());
        }
    }

    @PreDestroy
    public void contextDestroyed() {
        log.info((Object)"Stopping filter initializer");
        for (Map.Entry<String, ZuulFilter> entry : this.filters.entrySet()) {
            this.filterRegistry.remove(entry.getKey());
        }
        this.clearLoaderCache();
        TracerFactory.initialize(null);
        CounterFactory.initialize(null);
    }

    private void clearLoaderCache() {
        Field field = ReflectionUtils.findField(FilterLoader.class, (String)"hashFiltersByType");
        ReflectionUtils.makeAccessible((Field)field);
        Map cache = (Map)ReflectionUtils.getField((Field)field, (Object)this.filterLoader);
        cache.clear();
    }
}

