/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

@Deprecated
public class OAuth2TokenRelayFilter
extends ZuulFilter {
    private static final String ACCESS_TOKEN = "ACCESS_TOKEN";
    private static final String TOKEN_TYPE = "TOKEN_TYPE";
    private Map<String, ProxyAuthenticationProperties.Route> routes = new HashMap<String, ProxyAuthenticationProperties.Route>();
    private OAuth2RestOperations restTemplate;

    public OAuth2TokenRelayFilter(ProxyAuthenticationProperties properties) {
        this.routes = properties.getRoutes();
    }

    public void setRestTemplate(OAuth2RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public int filterOrder() {
        return 10;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        Object details;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof OAuth2Authentication && (details = auth.getDetails()) instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails oauth = (OAuth2AuthenticationDetails)details;
            RequestContext ctx = RequestContext.getCurrentContext();
            if (!this.isOauth2Route(ctx)) {
                return false;
            }
            ctx.set(ACCESS_TOKEN, (Object)oauth.getTokenValue());
            ctx.set(TOKEN_TYPE, (Object)(oauth.getTokenType() == null ? "Bearer" : oauth.getTokenType()));
            return true;
        }
        return false;
    }

    private boolean isOauth2Route(RequestContext ctx) {
        String id;
        return !ctx.containsKey((Object)"proxy") || !this.routes.containsKey(id = (String)ctx.get((Object)"proxy")) || ProxyAuthenticationProperties.Route.Scheme.OAUTH2.matches(this.routes.get(id).getScheme());
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        ctx.addZuulRequestHeader("authorization", ctx.get((Object)TOKEN_TYPE) + " " + this.getAccessToken(ctx));
        return null;
    }

    private String getAccessToken(RequestContext ctx) {
        String value = (String)ctx.get((Object)ACCESS_TOKEN);
        if (this.restTemplate != null) {
            OAuth2Authentication auth = (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
            if (this.restTemplate.getResource().getClientId().equals(auth.getOAuth2Request().getClientId())) {
                try {
                    value = this.restTemplate.getAccessToken().getValue();
                }
                catch (Exception e) {
                    ctx.set("error.status_code", (Object)401);
                    throw new BadCredentialsException("Cannot obtain valid access token");
                }
            }
        }
        return value;
    }
}

