/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.security;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.security.TracingSecurityContextChangedListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.context.SecurityContextChangedListener;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SecurityContextChangedListener.class})
@ConditionalOnProperty(value={"spring.sleuth.security.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceSecurityAutoConfiguration {
    @Bean
    public TracingSecurityContextChangedListener tracingSecurityContextChangedListener(Tracer tracer) {
        return new TracingSecurityContextChangedListener(tracer);
    }
}

