/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import brave.jms.JmsTracing;
import brave.propagation.CurrentTraceContext;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import javax.jms.MessageListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.MethodJmsListenerEndpoint;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.config.TracingMessagingMessageListenerAdapter;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.StringValueResolver;

public final class TracingJmsListenerEndpointRegistry
extends JmsListenerEndpointRegistry {
    private final BeanFactory beanFactory;
    private final JmsListenerEndpointRegistry delegate;
    private JmsTracing jmsTracing;
    private CurrentTraceContext currentTraceContext;
    final Field messageHandlerMethodFactoryField;
    final Field embeddedValueResolverField;

    public TracingJmsListenerEndpointRegistry(JmsListenerEndpointRegistry registry, BeanFactory beanFactory) {
        this.delegate = registry;
        this.beanFactory = beanFactory;
        this.messageHandlerMethodFactoryField = TracingJmsListenerEndpointRegistry.tryField("messageHandlerMethodFactory");
        this.embeddedValueResolverField = TracingJmsListenerEndpointRegistry.tryField("embeddedValueResolver");
    }

    private JmsTracing jmsTracing() {
        if (this.jmsTracing == null) {
            this.jmsTracing = (JmsTracing)this.beanFactory.getBean(JmsTracing.class);
        }
        return this.jmsTracing;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.delegate.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    public MessageListenerContainer getListenerContainer(String id) {
        return this.delegate.getListenerContainer(id);
    }

    public Set<String> getListenerContainerIds() {
        return this.delegate.getListenerContainerIds();
    }

    public Collection<MessageListenerContainer> getListenerContainers() {
        return this.delegate.getListenerContainers();
    }

    public void registerListenerContainer(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory) {
        this.delegate.registerListenerContainer(this.wrapEndpoint(endpoint), factory);
    }

    protected MessageListenerContainer createListenerContainer(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory) {
        return this.delegate.createListenerContainer(this.wrapEndpoint(endpoint), factory);
    }

    public int getPhase() {
        return this.delegate.getPhase();
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void stop(Runnable callback) {
        this.delegate.stop(callback);
    }

    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean isAutoStartup() {
        return this.delegate.isAutoStartup();
    }

    @Nullable
    static Field tryField(String name) {
        try {
            Field field = MethodJmsListenerEndpoint.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    static <T> T get(Object object, Field field) throws IllegalAccessException {
        return (T)field.get(object);
    }

    public void registerListenerContainer(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory, boolean startImmediately) {
        this.delegate.registerListenerContainer(this.wrapEndpoint(endpoint), factory, startImmediately);
    }

    private JmsListenerEndpoint wrapEndpoint(JmsListenerEndpoint endpoint) {
        if (endpoint instanceof MethodJmsListenerEndpoint) {
            return this.trace((MethodJmsListenerEndpoint)endpoint);
        }
        if (endpoint instanceof SimpleJmsListenerEndpoint) {
            return this.trace((SimpleJmsListenerEndpoint)endpoint);
        }
        return endpoint;
    }

    SimpleJmsListenerEndpoint trace(SimpleJmsListenerEndpoint source) {
        MessageListener delegate = source.getMessageListener();
        if (delegate == null) {
            return source;
        }
        source.setMessageListener(this.jmsTracing().messageListener(delegate, false));
        return source;
    }

    MethodJmsListenerEndpoint trace(MethodJmsListenerEndpoint source) {
        if (this.messageHandlerMethodFactoryField == null || this.embeddedValueResolverField == null) {
            return source;
        }
        MethodJmsListenerEndpoint dest = new MethodJmsListenerEndpoint(){

            protected MessagingMessageListenerAdapter createMessageListenerInstance() {
                return new TracingMessagingMessageListenerAdapter(TracingJmsListenerEndpointRegistry.this.jmsTracing(), TracingJmsListenerEndpointRegistry.this.currentTraceContext());
            }
        };
        dest.setId(source.getId());
        dest.setDestination(source.getDestination());
        dest.setSubscription(source.getSubscription());
        dest.setSelector(source.getSelector());
        dest.setConcurrency(source.getConcurrency());
        dest.setBean(source.getBean());
        dest.setMethod(source.getMethod());
        dest.setMostSpecificMethod(source.getMostSpecificMethod());
        try {
            dest.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)TracingJmsListenerEndpointRegistry.get(source, this.messageHandlerMethodFactoryField));
            dest.setEmbeddedValueResolver((StringValueResolver)TracingJmsListenerEndpointRegistry.get(source, this.embeddedValueResolverField));
        }
        catch (IllegalAccessException e) {
            return source;
        }
        return dest;
    }
}

