/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class ScopePassingSpanSubscriber<T>
implements SpanSubscription<T>,
Scannable {
    private static final Log log = LogFactory.getLog(ScopePassingSpanSubscriber.class);
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final CurrentTraceContext currentTraceContext;
    final TraceContext parent;
    private Subscription s;

    ScopePassingSpanSubscriber(Subscriber<? super T> subscriber, Context ctx, CurrentTraceContext currentTraceContext, @org.springframework.lang.Nullable TraceContext parent) {
        this.subscriber = subscriber;
        this.currentTraceContext = currentTraceContext;
        this.parent = parent;
        Context context = this.context = parent != null && !parent.equals(ctx.getOrDefault(TraceContext.class, null)) ? ctx.put(TraceContext.class, (Object)parent) : ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Parent span [" + parent + "], context [" + this.context + "]"));
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.s = subscription;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.s.request(n);
        }
    }

    public void cancel() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.s.cancel();
        }
    }

    public void onNext(T o) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.subscriber.onNext(o);
        }
    }

    public void onError(Throwable throwable) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.subscriber.onError(throwable);
        }
    }

    public void onComplete() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
            this.subscriber.onComplete();
        }
    }

    public Context currentContext() {
        return this.context;
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return key == Scannable.Attr.ACTUAL ? this.subscriber : null;
    }

    public String toString() {
        return "ScopePassingSpanSubscriber{subscriber=" + this.subscriber + ", parent=" + this.parent + "}";
    }
}

