/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.net.InetAddress;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.ZipkinProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DiscoveryClientHostLocator
implements HostLocator {
    private final DiscoveryClient client;
    private final ZipkinProperties zipkinProperties;

    @Deprecated
    public DiscoveryClientHostLocator(DiscoveryClient client) {
        this(client, new ZipkinProperties());
    }

    public DiscoveryClientHostLocator(DiscoveryClient client, ZipkinProperties zipkinProperties) {
        this.client = client;
        Assert.notNull((Object)this.client, (String)"client");
        this.zipkinProperties = zipkinProperties;
    }

    @Override
    public Host locate(Span span) {
        ServiceInstance instance = this.client.getLocalServiceInstance();
        String serviceId = StringUtils.hasText((String)this.zipkinProperties.getService().getName()) ? this.zipkinProperties.getService().getName() : instance.getServiceId();
        return new Host(serviceId, this.getIpAddress(instance), instance.getPort());
    }

    private String getIpAddress(ServiceInstance instance) {
        try {
            InetAddress address = InetAddress.getByName(instance.getHost());
            return address.getHostAddress();
        }
        catch (Exception e) {
            return "0.0.0.0";
        }
    }
}

