/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.metric.TraceMetricsAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.PercentageBasedSampler;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.stream.DiscoveryClientHostLocator;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.ServerPropertiesHostLocator;
import org.springframework.cloud.sleuth.stream.SleuthSource;
import org.springframework.cloud.sleuth.stream.SleuthStreamProperties;
import org.springframework.cloud.sleuth.stream.StreamSpanReporter;
import org.springframework.cloud.sleuth.stream.TracerIgnoringChannelInterceptor;
import org.springframework.cloud.sleuth.stream.ZipkinProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.config.ChannelBindingAutoConfiguration;
import org.springframework.cloud.stream.config.ChannelsEndpointAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

@Configuration
@EnableConfigurationProperties(value={SleuthStreamProperties.class, SamplerProperties.class, ZipkinProperties.class})
@AutoConfigureAfter(value={TraceMetricsAutoConfiguration.class})
@AutoConfigureBefore(value={ChannelBindingAutoConfiguration.class, TraceAutoConfiguration.class, ChannelsEndpointAutoConfiguration.class})
@EnableBinding(value={SleuthSource.class})
@ConditionalOnProperty(value={"spring.sleuth.stream.enabled"}, matchIfMissing=true)
public class SleuthStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Sampler defaultTraceSampler(SamplerProperties config) {
        return new PercentageBasedSampler(config);
    }

    @Bean
    @GlobalChannelInterceptor(patterns={"sleuth"}, order=-2147483648)
    public ChannelInterceptor zipkinChannelInterceptor(SpanMetricReporter spanMetricReporter) {
        return new TracerIgnoringChannelInterceptor(spanMetricReporter);
    }

    @Bean
    @ConditionalOnMissingBean
    public StreamSpanReporter sleuthStreamSpanReporter(HostLocator endpointLocator, SpanMetricReporter spanMetricReporter, Environment environment) {
        return new StreamSpanReporter(endpointLocator, spanMetricReporter, environment);
    }

    @Bean(name={"streamSpanReporterPoller"})
    @ConditionalOnMissingBean(name={"streamSpanReporterPoller"})
    public PollerMetadata defaultStreamSpanReporterPoller(SleuthStreamProperties sleuth) {
        PollerMetadata poller = new PollerMetadata();
        poller.setTrigger((Trigger)new PeriodicTrigger(sleuth.getPoller().getFixedDelay()));
        poller.setMaxMessagesPerPoll((long)sleuth.getPoller().getMaxMessagesPerPoll());
        return poller;
    }

    @Configuration
    @ConditionalOnClass(value={DiscoveryClient.class})
    @ConditionalOnMissingBean(value={HostLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="true")
    protected static class DiscoveryClientEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Value(value="${spring.application.name:unknown}")
        private String appName;
        @Autowired(required=false)
        private DiscoveryClient client;

        protected DiscoveryClientEndpointLocatorConfiguration() {
        }

        @Bean
        public HostLocator zipkinEndpointLocator() {
            if (this.client != null) {
                return new DiscoveryClientHostLocator(this.client, this.zipkinProperties);
            }
            return new ServerPropertiesHostLocator(this.serverProperties, this.appName, this.zipkinProperties, this.inetUtils);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={HostLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="false", matchIfMissing=true)
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired
        private InetUtils inetUtils;
        @Value(value="${spring.application.name:unknown}")
        private String appName;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public HostLocator zipkinEndpointLocator() {
            return new ServerPropertiesHostLocator(this.serverProperties, this.appName, this.zipkinProperties, this.inetUtils);
        }
    }
}

