/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.Spans;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.Poller;

@MessageEndpoint
public class StreamSpanReporter
implements SpanReporter {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final List<String> RPC_EVENTS = Arrays.asList("cr", "cs", "sr", "ss");
    public static final String POLLER = "streamSpanReporterPoller";
    private BlockingQueue<Span> queue = new LinkedBlockingQueue<Span>(1000);
    private final HostLocator endpointLocator;
    private final SpanMetricReporter spanMetricReporter;
    private final Environment environment;

    @Deprecated
    public StreamSpanReporter(HostLocator endpointLocator, SpanMetricReporter spanMetricReporter) {
        this(endpointLocator, spanMetricReporter, null);
    }

    public StreamSpanReporter(HostLocator endpointLocator, SpanMetricReporter spanMetricReporter, Environment environment) {
        this.endpointLocator = endpointLocator;
        this.spanMetricReporter = spanMetricReporter;
        this.environment = environment;
    }

    public void setQueue(BlockingQueue<Span> queue) {
        this.queue = queue;
    }

    @InboundChannelAdapter(value="sleuth", poller={@Poller(value="streamSpanReporterPoller")})
    public Spans poll() {
        LinkedList<Span> result = new LinkedList<Span>();
        this.queue.drainTo(result);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Span span = (Span)iterator.next();
            if (span.getName() == null || !span.getName().equals("message/sleuth")) continue;
            iterator.remove();
        }
        if (result.isEmpty()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processed [" + result.size() + "] spans"));
        }
        this.spanMetricReporter.incrementAcceptedSpans((long)result.size());
        return new Spans(this.endpointLocator.locate((Span)result.get(0)), result);
    }

    public void report(Span span) {
        if (span.isExportable()) {
            try {
                if (this.environment != null) {
                    this.processLogs(span);
                }
                this.queue.add(span);
            }
            catch (Exception e) {
                this.spanMetricReporter.incrementDroppedSpans(1L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The span " + span + " will not be sent to Zipkin due to [" + e + "]"));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("The span " + span + " will not be sent to Zipkin due to sampling"));
        }
    }

    private void processLogs(Span span) {
        for (Log spanLog : span.logs()) {
            if (!RPC_EVENTS.contains(spanLog.getEvent())) continue;
            span.tag("spring.instance_id", IdUtils.getDefaultInstanceId((PropertyResolver)this.environment));
        }
    }
}

