/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.stream.Spans;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;

class TracerIgnoringChannelInterceptor
extends ChannelInterceptorAdapter {
    private final SpanMetricReporter spanMetricReporter;

    public TracerIgnoringChannelInterceptor(SpanMetricReporter spanMetricReporter) {
        this.spanMetricReporter = spanMetricReporter;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        return MessageBuilder.fromMessage(message).setHeader("spanSampled", (Object)"0").build();
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (!(message.getPayload() instanceof Spans)) {
            return;
        }
        Spans spans = (Spans)message.getPayload();
        int spanNumber = spans.getSpans().size();
        if (sent) {
            this.spanMetricReporter.incrementAcceptedSpans((long)spanNumber);
        } else {
            this.spanMetricReporter.incrementDroppedSpans((long)spanNumber);
        }
    }
}

