/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.Spans;
import org.springframework.cloud.sleuth.zipkin.stream.ZipkinMessageListener;
import org.springframework.util.StringUtils;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

final class ConvertToZipkinSpanList {
    private static final List<String> ZIPKIN_START_EVENTS = Arrays.asList("cr", "sr");
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ConvertToZipkinSpanList.class);

    ConvertToZipkinSpanList() {
    }

    static List<zipkin.Span> convert(Spans input) {
        Host host = input.getHost();
        ArrayList<zipkin.Span> result = new ArrayList<zipkin.Span>(input.getSpans().size());
        for (Span span : input.getSpans()) {
            if (!span.getName().equals("message:sleuth")) {
                result.add(ConvertToZipkinSpanList.convert(span, host));
                continue;
            }
            log.warn((Object)("Message tracing cycle detected for: " + input));
        }
        return result;
    }

    static zipkin.Span convert(Span span, Host host) {
        Span.Builder zipkinSpan = zipkin.Span.builder();
        Endpoint ep = Endpoint.builder().serviceName(host.getServiceName()).ipv4(host.getIpv4()).port(host.getPort() != null ? host.getPort() : 0).build();
        if (ConvertToZipkinSpanList.notClientOrServer(span)) {
            ConvertToZipkinSpanList.ensureLocalComponent(span, zipkinSpan, ep);
        }
        ZipkinMessageListener.addZipkinAnnotations(zipkinSpan, span, ep);
        ZipkinMessageListener.addZipkinBinaryAnnotations(zipkinSpan, span, ep);
        if (ConvertToZipkinSpanList.hasClientSend(span)) {
            ConvertToZipkinSpanList.ensureServerAddr(span, zipkinSpan);
        }
        if (!span.isRemote()) {
            if (Boolean.TRUE.equals(span.isShared())) {
                zipkinSpan.timestamp(null).duration(null);
            } else {
                zipkinSpan.timestamp(Long.valueOf(span.getBegin() * 1000L));
                if (!span.isRunning()) {
                    zipkinSpan.duration(Long.valueOf(ConvertToZipkinSpanList.calculateDurationInMicros(span)));
                }
            }
        }
        zipkinSpan.traceIdHigh(span.getTraceIdHigh());
        zipkinSpan.traceId(span.getTraceId());
        if (span.getParents().size() > 0) {
            if (span.getParents().size() > 1 && log.isDebugEnabled()) {
                log.debug((Object)("zipkin doesn't support spans with multiple parents.  Omitting other parents for " + span));
            }
            zipkinSpan.parentId((Long)span.getParents().get(0));
        }
        zipkinSpan.id(span.getSpanId());
        if (StringUtils.hasText((String)span.getName())) {
            zipkinSpan.name(span.getName());
        }
        return zipkinSpan.build();
    }

    private static void ensureLocalComponent(Span span, Span.Builder zipkinSpan, Endpoint ep) {
        if (span.tags().containsKey("lc")) {
            return;
        }
        String processId = span.getProcessId() != null ? span.getProcessId().toLowerCase() : "unknown";
        zipkinSpan.addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)processId, (Endpoint)ep));
    }

    private static void ensureServerAddr(Span span, Span.Builder zipkinSpan) {
        if (span.tags().containsKey("peer.service")) {
            Endpoint endpoint = Endpoint.builder().serviceName((String)span.tags().get("peer.service")).build();
            zipkinSpan.addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)endpoint));
        }
    }

    private static boolean notClientOrServer(Span span) {
        for (Log log : span.logs()) {
            if (!ZIPKIN_START_EVENTS.contains(log.getEvent())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasClientSend(Span span) {
        for (Log log : span.logs()) {
            if (!"cs".equals(log.getEvent())) continue;
            return !span.tags().containsKey("sa");
        }
        return false;
    }

    private static long calculateDurationInMicros(Span span) {
        Log clientSend = ConvertToZipkinSpanList.hasLog("cs", span);
        Log clientReceived = ConvertToZipkinSpanList.hasLog("cr", span);
        if (clientSend != null && clientReceived != null) {
            return (clientReceived.getTimestamp() - clientSend.getTimestamp()) * 1000L;
        }
        return span.getAccumulatedMicros();
    }

    private static Log hasLog(String logName, Span span) {
        for (Log log : span.logs()) {
            if (!logName.equals(log.getEvent())) continue;
            return log;
        }
        return null;
    }
}

