/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public class ZipkinSpanListener
implements SpanReporter {
    private static final List<String> ZIPKIN_START_EVENTS = Arrays.asList("cr", "sr");
    private static final List<String> RPC_EVENTS = Arrays.asList("cr", "cs", "sr", "ss");
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ZipkinSpanListener.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] UNKNOWN_BYTES = "unknown".getBytes(UTF_8);
    private final ZipkinSpanReporter reporter;
    private final Environment environment;
    EndpointLocator endpointLocator;

    @Deprecated
    public ZipkinSpanListener(ZipkinSpanReporter reporter, EndpointLocator endpointLocator) {
        this(reporter, endpointLocator, null);
    }

    public ZipkinSpanListener(ZipkinSpanReporter reporter, EndpointLocator endpointLocator, Environment environment) {
        this.reporter = reporter;
        this.endpointLocator = endpointLocator;
        this.environment = environment;
    }

    zipkin.Span convert(Span span) {
        Span.Builder zipkinSpan = zipkin.Span.builder();
        Endpoint endpoint = this.endpointLocator.local();
        this.processLogs(span, zipkinSpan, endpoint);
        this.addZipkinAnnotations(zipkinSpan, span, endpoint);
        this.addZipkinBinaryAnnotations(zipkinSpan, span, endpoint);
        if (!span.isRemote()) {
            zipkinSpan.timestamp(Long.valueOf(span.getBegin() * 1000L));
            if (!span.isRunning()) {
                zipkinSpan.duration(Long.valueOf(this.calculateDurationInMicros(span)));
            }
        }
        zipkinSpan.traceIdHigh(span.getTraceIdHigh());
        zipkinSpan.traceId(span.getTraceId());
        if (span.getParents().size() > 0) {
            if (span.getParents().size() > 1) {
                log.error((Object)("Zipkin doesn't support spans with multiple parents. Omitting other parents for " + span));
            }
            zipkinSpan.parentId((Long)span.getParents().get(0));
        }
        zipkinSpan.id(span.getSpanId());
        if (StringUtils.hasText((String)span.getName())) {
            zipkinSpan.name(span.getName());
        }
        return zipkinSpan.build();
    }

    private void ensureLocalComponent(Span span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("lc")) {
            return;
        }
        byte[] processId = span.getProcessId() != null ? span.getProcessId().toLowerCase().getBytes(UTF_8) : UNKNOWN_BYTES;
        BinaryAnnotation component = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key("lc").value(processId).endpoint(localEndpoint).build();
        zipkinSpan.addBinaryAnnotation(component);
    }

    private void ensureServerAddr(Span span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("peer.service")) {
            zipkinSpan.addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)localEndpoint.toBuilder().serviceName((String)span.tags().get("peer.service")).build()));
        }
    }

    private void processLogs(Span span, Span.Builder zipkinSpan, Endpoint endpoint) {
        boolean notClientOrServer = true;
        boolean hasClientSend = false;
        boolean instanceIdToTag = false;
        for (Log log : span.logs()) {
            if (RPC_EVENTS.contains(log.getEvent())) {
                instanceIdToTag = true;
            }
            if (ZIPKIN_START_EVENTS.contains(log.getEvent())) {
                notClientOrServer = false;
            }
            if (!"cs".equals(log.getEvent())) continue;
            hasClientSend = !span.tags().containsKey("sa");
        }
        if (notClientOrServer) {
            this.ensureLocalComponent(span, zipkinSpan, endpoint);
        }
        if (hasClientSend) {
            this.ensureServerAddr(span, zipkinSpan, endpoint);
        }
        if (instanceIdToTag && this.environment != null) {
            this.setInstanceIdIfPresent(zipkinSpan, endpoint, "spring.instance_id");
        }
    }

    private void setInstanceIdIfPresent(Span.Builder zipkinSpan, Endpoint endpoint, String key) {
        String property = IdUtils.getDefaultInstanceId((PropertyResolver)this.environment);
        if (StringUtils.hasText((String)property)) {
            this.addZipkinBinaryAnnotation(key, property, endpoint, zipkinSpan);
        }
    }

    private void addZipkinAnnotations(Span.Builder zipkinSpan, Span span, Endpoint endpoint) {
        for (Log ta : span.logs()) {
            Annotation zipkinAnnotation = Annotation.builder().endpoint(endpoint).timestamp(ta.getTimestamp() * 1000L).value(ta.getEvent()).build();
            zipkinSpan.addAnnotation(zipkinAnnotation);
        }
    }

    private void addZipkinBinaryAnnotations(Span.Builder zipkinSpan, Span span, Endpoint ep) {
        for (Map.Entry e : span.tags().entrySet()) {
            this.addZipkinBinaryAnnotation((String)e.getKey(), (String)e.getValue(), ep, zipkinSpan);
        }
    }

    private void addZipkinBinaryAnnotation(String key, String value, Endpoint ep, Span.Builder zipkinSpan) {
        BinaryAnnotation binaryAnn = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key(key).value(value.getBytes(UTF_8)).endpoint(ep).build();
        zipkinSpan.addBinaryAnnotation(binaryAnn);
    }

    private long calculateDurationInMicros(Span span) {
        Log clientSend = this.hasLog("cs", span);
        Log clientReceived = this.hasLog("cr", span);
        if (clientSend != null && clientReceived != null) {
            return (clientReceived.getTimestamp() - clientSend.getTimestamp()) * 1000L;
        }
        return span.getAccumulatedMicros();
    }

    private Log hasLog(String logName, Span span) {
        for (Log log : span.logs()) {
            if (!logName.equals(log.getEvent())) continue;
            return log;
        }
        return null;
    }

    public void report(Span span) {
        if (span.isExportable()) {
            this.reporter.report(this.convert(span));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("The span " + span + " will not be sent to Zipkin due to sampling"));
        }
    }
}

