/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import zipkin.Endpoint;

public class ServerPropertiesEndpointLocator
implements EndpointLocator,
EnvironmentAware {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String IP_ADDRESS_PROP_NAME = "spring.cloud.client.ipAddress";
    private final ServerProperties serverProperties;
    private final String appName;
    private final InetUtils inetUtils;
    private final ZipkinProperties zipkinProperties;
    private Integer port;
    private Environment environment;

    @Deprecated
    public ServerPropertiesEndpointLocator(ServerProperties serverProperties, String appName) {
        this(serverProperties, appName, new ZipkinProperties(), null);
    }

    public ServerPropertiesEndpointLocator(ServerProperties serverProperties, String appName, ZipkinProperties zipkinProperties, InetUtils inetUtils) {
        this.serverProperties = serverProperties;
        this.appName = appName;
        this.zipkinProperties = zipkinProperties;
        this.inetUtils = inetUtils == null ? new InetUtils(new InetUtilsProperties()) : inetUtils;
    }

    @Override
    public Endpoint local() {
        String serviceName;
        String string = serviceName = StringUtils.hasText((String)this.zipkinProperties.getService().getName()) ? this.zipkinProperties.getService().getName() : this.appName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span will contain serviceName [" + serviceName + "]"));
        }
        return Endpoint.builder().serviceName(serviceName).ipv4(this.getAddress()).port(this.getPort().intValue()).build();
    }

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void grabPort(EmbeddedServletContainerInitializedEvent event) {
        this.port = event.getEmbeddedServletContainer().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null && this.serverProperties.getPort() > 0 ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private int getAddress() {
        if (this.serverProperties != null && this.serverProperties.getAddress() != null) {
            return ByteBuffer.wrap(this.serverProperties.getAddress().getAddress()).getInt();
        }
        if (this.environment != null) {
            String ipAddress = (String)this.environment.getProperty(IP_ADDRESS_PROP_NAME, String.class);
            return InetUtils.getIpAddressAsInt((String)ipAddress);
        }
        return ByteBuffer.wrap(this.inetUtils.findFirstNonLoopbackAddress().getAddress()).getInt();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

