/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.common.AbstractKafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.common.TopicInformation;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class KafkaBinderHealthIndicator
extends AbstractKafkaBinderHealthIndicator {
    private final KafkaMessageChannelBinder binder;

    public KafkaBinderHealthIndicator(KafkaMessageChannelBinder binder, ConsumerFactory<?, ?> consumerFactory) {
        super(consumerFactory);
        this.binder = binder;
    }

    protected ExecutorService createHealthBinderExecutorService() {
        return Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("kafka-binder-health-"));
    }

    protected Map<String, TopicInformation> getTopicsInUse() {
        return this.binder.getTopicsInUse();
    }

    protected Health buildBinderSpecificHealthDetails() {
        List<AbstractMessageListenerContainer<?, ?>> listenerContainers = this.binder.getKafkaMessageListenerContainers();
        if (listenerContainers.isEmpty()) {
            return Health.unknown().build();
        }
        Status status = Status.UP;
        ArrayList containersDetails = new ArrayList();
        for (AbstractMessageListenerContainer<?, ?> container : listenerContainers) {
            HashMap<String, Object> containerDetails = new HashMap<String, Object>();
            boolean isRunning = container.isRunning();
            boolean isOk = container.isInExpectedState();
            if (!isOk) {
                status = Status.DOWN;
            }
            containerDetails.put("isRunning", isRunning);
            containerDetails.put("isStoppedAbnormally", !isRunning && !isOk);
            containerDetails.put("isPaused", container.isContainerPaused());
            containerDetails.put("listenerId", container.getListenerId());
            containerDetails.put("groupId", container.getGroupId());
            containersDetails.add(containerDetails);
        }
        return Health.status((Status)status).withDetail("listenerContainers", containersDetails).build();
    }
}

