/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.messaging.MessageHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration.class})
public class ObservationAutoConfiguration {
    @Bean
    @Order(value=-2147483648)
    ListenerContainerCustomizer<MessageListenerContainer> observedListenerContainerCustomizer(ApplicationContext applicationContext) {
        return (container, destinationName, group) -> {
            if (container instanceof AbstractMessageListenerContainer) {
                AbstractMessageListenerContainer abstractMessageListenerContainer = (AbstractMessageListenerContainer)container;
                abstractMessageListenerContainer.setObservationEnabled(true);
                abstractMessageListenerContainer.setApplicationContext(applicationContext);
            }
        };
    }

    @Bean
    @Order(value=-2147483648)
    ProducerMessageHandlerCustomizer<MessageHandler> observedProducerMessageHandlerCustomizer(ApplicationContext applicationContext) {
        return (handler, destinationName) -> {
            if (handler instanceof AmqpOutboundEndpoint) {
                AmqpOutboundEndpoint amqpOutboundEndpoint = (AmqpOutboundEndpoint)handler;
                amqpOutboundEndpoint.getRabbitTemplate().setObservationEnabled(true);
                amqpOutboundEndpoint.getRabbitTemplate().setApplicationContext(applicationContext);
            }
        };
    }
}

