/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.Map;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class BindableFunctionProxyFactory
extends BindableProxyFactory {
    private final int inputCount;
    private final int outputCount;
    private final String functionDefinition;
    private final StreamFunctionProperties functionProperties;

    BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties) {
        super(null);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.functionDefinition = functionDefinition;
        this.functionProperties = functionProperties;
    }

    @Override
    public void afterPropertiesSet() {
        int i;
        Assert.notEmpty((Map)this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        if (this.inputCount > 0) {
            for (i = 0; i < this.inputCount; ++i) {
                this.createInput(this.buildInputNameForIndex(i));
            }
        }
        if (this.outputCount > 0) {
            for (i = 0; i < this.outputCount; ++i) {
                this.createOutput(this.buildOutputNameForIndex(i));
            }
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.type;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected String getFunctionDefinition() {
        return this.functionDefinition;
    }

    protected String getInputName(int index) {
        return CollectionUtils.isEmpty(this.getInputs()) ? null : this.getInputs().toArray(new String[0])[index];
    }

    protected String getOutputName(int index) {
        String outputName = null;
        if (this.outputCount > 0) {
            outputName = CollectionUtils.isEmpty(this.getOutputs()) ? null : this.getOutputs().toArray(new String[0])[index];
        }
        return outputName;
    }

    protected boolean isMultiple() {
        return this.inputCount > 1 || this.outputCount > 1;
    }

    private String buildInputNameForIndex(int index) {
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "in" + "-" + index;
    }

    private String buildOutputNameForIndex(int index) {
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "out" + "-" + index;
    }

    private void createInput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        this.inputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(SubscribableChannel.class).createInput(name), true));
    }

    private void createOutput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        this.outputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(MessageChannel.class).createOutput(name), true));
    }
}

