/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RandomRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.zookeeper.discovery.dependency.LoadBalancerType;
import org.springframework.cloud.zookeeper.discovery.dependency.StickyRule;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;

public class DependenciesBasedLoadBalancer
extends DynamicServerListLoadBalancer {
    private static final Log log = LogFactory.getLog(DependenciesBasedLoadBalancer.class);
    private final Map<String, IRule> ruleCache = new ConcurrentHashMap<String, IRule>();
    private final ZookeeperDependencies zookeeperDependencies;

    public DependenciesBasedLoadBalancer(ZookeeperDependencies zookeeperDependencies, ServerList<?> serverList, IClientConfig config, IPing iPing) {
        super(config);
        this.zookeeperDependencies = zookeeperDependencies;
        this.setServersList(serverList.getInitialListOfServers());
        this.setPing(iPing);
        this.setServerListImpl(serverList);
    }

    public Server chooseServer(Object key) {
        String keyAsString = (String)key;
        ZookeeperDependency dependency = this.zookeeperDependencies.getDependencyForAlias(keyAsString);
        log.debug((Object)String.format("Current dependencies are [%s]", this.zookeeperDependencies));
        if (dependency == null) {
            log.debug((Object)String.format("No dependency found for alias [%s] - will use the default rule which is [%s]", keyAsString, this.rule));
            return this.rule.choose(key);
        }
        this.cacheEntryIfMissing(keyAsString, dependency);
        log.debug((Object)String.format("Will try to retrieve dependency for key [%s]. Current cache contents [%s]", keyAsString, this.ruleCache));
        this.updateListOfServers();
        return this.ruleCache.get(keyAsString).choose(key);
    }

    private void cacheEntryIfMissing(String keyAsString, ZookeeperDependency dependency) {
        if (!this.ruleCache.containsKey(keyAsString)) {
            log.debug((Object)String.format("Cache doesn't contain entry for [%s]", keyAsString));
            this.ruleCache.put(keyAsString, this.chooseRuleForLoadBalancerType(dependency.getLoadBalancerType()));
        }
    }

    private IRule chooseRuleForLoadBalancerType(LoadBalancerType type) {
        switch (type) {
            case ROUND_ROBIN: {
                return this.getRoundRobinRule();
            }
            case RANDOM: {
                return this.getRandomRule();
            }
            case STICKY: {
                return this.getStickyRule();
            }
        }
        throw new IllegalArgumentException("Unknown load balancer type " + (Object)((Object)type));
    }

    private RoundRobinRule getRoundRobinRule() {
        return new RoundRobinRule((ILoadBalancer)this);
    }

    private IRule getRandomRule() {
        RandomRule randomRule = new RandomRule();
        randomRule.setLoadBalancer((ILoadBalancer)this);
        return randomRule;
    }

    private IRule getStickyRule() {
        StickyRule stickyRule = new StickyRule((IRule)this.getRoundRobinRule());
        stickyRule.setLoadBalancer((ILoadBalancer)this);
        return stickyRule;
    }
}

