/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.zookeeper.discovery.DependencyPathUtils;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;

public class ZookeeperServiceInstances
implements Iterable<ServiceInstance<ZookeeperInstance>> {
    private static final Log log = LogFactory.getLog(ZookeeperServiceInstances.class);
    private ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final ZookeeperDependencies zookeeperDependencies;
    private final ZookeeperDiscoveryProperties zookeeperDiscoveryProperties;
    private final List<ServiceInstance<ZookeeperInstance>> allInstances;
    private final CuratorFramework curator;

    @Deprecated
    public ZookeeperServiceInstances(ZookeeperServiceDiscovery zookeeperServiceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.curator = zookeeperServiceDiscovery.getCurator();
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
        this.allInstances = this.getZookeeperInstances();
    }

    public ZookeeperServiceInstances(CuratorFramework curator, ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.curator = curator;
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
        this.allInstances = this.getZookeeperInstances();
    }

    private List<ServiceInstance<ZookeeperInstance>> getZookeeperInstances() {
        ArrayList<ServiceInstance<ZookeeperInstance>> allInstances = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        try {
            Collection<String> namesToQuery = this.getNamesToQuery();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Querying the following names [" + namesToQuery + "]"));
            }
            for (String name : namesToQuery) {
                allInstances.addAll(this.nestedInstances(allInstances, name));
            }
            return allInstances;
        }
        catch (Exception e) {
            log.debug((Object)"Exception occurred while trying to build the list of instances", (Throwable)e);
            return allInstances;
        }
    }

    private List<ServiceInstance<ZookeeperInstance>> nestedInstances(List<ServiceInstance<ZookeeperInstance>> accumulator, String name) throws Exception {
        String parentPath = this.prepareQueryName(name);
        Collection<ServiceInstance<ZookeeperInstance>> childrenInstances = this.tryToGetInstances(parentPath);
        if (childrenInstances != null) {
            return this.convertCollectionToList(childrenInstances);
        }
        try {
            List children = (List)this.curator.getChildren().forPath(parentPath);
            return this.iterateOverChildren(accumulator, parentPath, children);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Exception occurred while trying to retrieve children of [" + parentPath + "]"), (Throwable)e);
            }
            return this.injectZookeeperServiceInstances(accumulator, parentPath);
        }
    }

    private String prepareQueryName(String name) {
        String root = this.zookeeperDiscoveryProperties.getRoot();
        return name.startsWith(root) ? name : root + name;
    }

    private Collection<ServiceInstance<ZookeeperInstance>> tryToGetInstances(String path) {
        try {
            return this.getServiceDiscovery().queryForInstances(this.getPathWithoutRoot(path));
        }
        catch (Exception e) {
            log.trace((Object)("Exception occurred while trying to retrieve instances of [" + path + "]"), (Throwable)e);
            return null;
        }
    }

    private ServiceDiscovery<ZookeeperInstance> getServiceDiscovery() {
        if (this.serviceDiscovery != null) {
            return this.serviceDiscovery;
        }
        return this.zookeeperServiceDiscovery.getServiceDiscoveryRef().get();
    }

    private String getPathWithoutRoot(String path) {
        return path.substring(this.zookeeperDiscoveryProperties.getRoot().length());
    }

    private List<ServiceInstance<ZookeeperInstance>> injectZookeeperServiceInstances(List<ServiceInstance<ZookeeperInstance>> accumulator, String name) throws Exception {
        Collection instances = this.getServiceDiscovery().queryForInstances(name);
        accumulator.addAll(this.convertCollectionToList(instances));
        return accumulator;
    }

    private List<ServiceInstance<ZookeeperInstance>> convertCollectionToList(Collection<ServiceInstance<ZookeeperInstance>> instances) {
        ArrayList<ServiceInstance<ZookeeperInstance>> serviceInstances = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        for (ServiceInstance<ZookeeperInstance> instance : instances) {
            serviceInstances.add(instance);
        }
        return serviceInstances;
    }

    private List<ServiceInstance<ZookeeperInstance>> iterateOverChildren(List<ServiceInstance<ZookeeperInstance>> accumulator, String parentPath, List<String> children) throws Exception {
        ArrayList<ServiceInstance<ZookeeperInstance>> lists = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        for (String child : children) {
            lists.addAll(this.nestedInstances(accumulator, parentPath + "/" + child));
        }
        return lists;
    }

    private Collection<String> getNamesToQuery() throws Exception {
        if (this.zookeeperDependencies == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using direct name resolution instead of dependency based one");
            }
            ArrayList<String> names = new ArrayList<String>();
            for (String name : this.getServiceDiscovery().queryForNames()) {
                names.add(DependencyPathUtils.sanitize(name));
            }
            return names;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using dependency based names to query");
        }
        return this.zookeeperDependencies.getDependencyNames();
    }

    @Override
    public Iterator<ServiceInstance<ZookeeperInstance>> iterator() {
        return this.allInstances.iterator();
    }
}

