/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.DefaultPersistentPropertyPath;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMappingContext<E extends MutablePersistentEntity<?, P>, P extends PersistentProperty<P>>
implements MappingContext<E, P>,
ApplicationEventPublisherAware,
InitializingBean {
    private final Map<TypeInformation<?>, E> persistentEntities = new HashMap();
    private ApplicationEventPublisher applicationEventPublisher;
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private boolean strict = false;
    private SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypes) {
        this.simpleTypeHolder = simpleTypes == null ? new SimpleTypeHolder() : simpleTypes;
    }

    @Override
    public Collection<E> getPersistentEntities() {
        try {
            this.read.lock();
            Set<E> set = Collections.unmodifiableSet(new HashSet<E>(this.persistentEntities.values()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public E getPersistentEntity(Class<?> type) {
        return (E)this.getPersistentEntity(ClassTypeInformation.from(type));
    }

    @Override
    public boolean hasPersistentEntityFor(Class<?> type) {
        return type == null ? false : this.persistentEntities.containsKey(ClassTypeInformation.from(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getPersistentEntity(TypeInformation<?> type) {
        Assert.notNull(type);
        try {
            this.read.lock();
            MutablePersistentEntity entity = (MutablePersistentEntity)this.persistentEntities.get(type);
            if (entity != null) {
                MutablePersistentEntity mutablePersistentEntity = entity;
                return (E)mutablePersistentEntity;
            }
        }
        finally {
            this.read.unlock();
        }
        if (!this.shouldCreatePersistentEntityFor(type)) {
            return null;
        }
        if (this.strict) {
            throw new MappingException("Unknown persistent entity " + type);
        }
        return this.addPersistentEntity(type);
    }

    @Override
    public E getPersistentEntity(P persistentProperty) {
        if (persistentProperty == null) {
            return null;
        }
        TypeInformation<?> typeInfo = persistentProperty.getTypeInformation();
        return (E)this.getPersistentEntity((TypeInformation)typeInfo.getActualType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(PropertyPath propertyPath) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        return this.getPersistentPropertyPath(propertyPath.toDotPath(), propertyPath.getOwningType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, Class<?> type) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.getPersistentPropertyPath(propertyPath, ClassTypeInformation.from(type));
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(InvalidPersistentPropertyPath invalidPath) {
        return this.getPersistentPropertyPath(invalidPath.getResolvedPath(), invalidPath.getType());
    }

    @Override
    private PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, TypeInformation<?> type) {
        return this.getPersistentPropertyPath(Arrays.asList(propertyPath.split("\\.")), type);
    }

    private PersistentPropertyPath<P> getPersistentPropertyPath(Collection<String> parts, TypeInformation<?> type) {
        DefaultPersistentPropertyPath path = DefaultPersistentPropertyPath.empty();
        Iterator<String> iterator = parts.iterator();
        PersistentEntity current = this.getPersistentEntity((TypeInformation)type);
        while (iterator.hasNext()) {
            String segment = iterator.next();
            Object persistentProperty = current.getPersistentProperty(segment);
            if (persistentProperty == null) {
                String source = StringUtils.collectionToDelimitedString(parts, (String)".");
                String resolvedPath = path.toDotPath();
                throw new InvalidPersistentPropertyPath(source, type, segment, resolvedPath, String.format("No property %s found on %s!", segment, current.getName()));
            }
            path = path.append(persistentProperty);
            if (!iterator.hasNext()) continue;
            current = this.getPersistentEntity((TypeInformation)persistentProperty.getTypeInformation().getActualType());
        }
        return path;
    }

    protected E addPersistentEntity(Class<?> type) {
        return this.addPersistentEntity(ClassTypeInformation.from(type));
    }

    protected E addPersistentEntity(TypeInformation<?> typeInformation) {
        MutablePersistentEntity persistentEntity = (MutablePersistentEntity)this.persistentEntities.get(typeInformation);
        if (persistentEntity != null) {
            return (E)persistentEntity;
        }
        Class<?> type = typeInformation.getType();
        try {
            this.write.lock();
            E entity = this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(typeInformation, entity);
            PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(type);
            HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : pds) {
                descriptors.put(descriptor.getName(), descriptor);
            }
            try {
                PersistentPropertyCreator persistentPropertyCreator = new PersistentPropertyCreator(this, (MutablePersistentEntity)entity, descriptors);
                ReflectionUtils.doWithFields(type, (ReflectionUtils.FieldCallback)persistentPropertyCreator, (ReflectionUtils.FieldFilter)PersistentPropertyFilter.INSTANCE);
                persistentPropertyCreator.addPropertiesForRemainingDescriptors();
                entity.verify();
            }
            catch (MappingException mappingException) {
                this.persistentEntities.remove(typeInformation);
                throw mappingException;
            }
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent(new MappingContextEvent(this, entity));
            }
            E e = entity;
            return e;
        }
        catch (BeansException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Collection<TypeInformation<?>> getManagedTypes() {
        try {
            this.read.lock();
            Set<TypeInformation<?>> set = Collections.unmodifiableSet(new HashSet(this.persistentEntities.keySet()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    protected abstract <T> E createPersistentEntity(TypeInformation<T> var1);

    protected abstract P createPersistentProperty(Field var1, PropertyDescriptor var2, E var3, SimpleTypeHolder var4);

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        for (Class<?> initialEntity : this.initialEntitySet) {
            this.addPersistentEntity(initialEntity);
        }
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return !this.simpleTypeHolder.isSimpleType(type.getType());
    }

    static enum PersistentPropertyFilter implements ReflectionUtils.FieldFilter
    {
        INSTANCE;

        private static final Iterable<PropertyMatch> UNMAPPED_PROPERTIES;

        public boolean matches(Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            for (PropertyMatch candidate : UNMAPPED_PROPERTIES) {
                if (!candidate.matches(field.getName(), field.getType())) continue;
                return false;
            }
            return true;
        }

        public boolean matches(PropertyDescriptor descriptor) {
            Assert.notNull((Object)descriptor, (String)"PropertyDescriptor must not be null!");
            if (descriptor.getReadMethod() == null && descriptor.getWriteMethod() == null) {
                return false;
            }
            for (PropertyMatch candidate : UNMAPPED_PROPERTIES) {
                if (!candidate.matches(descriptor.getName(), descriptor.getPropertyType())) continue;
                return false;
            }
            return true;
        }

        static {
            HashSet<PropertyMatch> matches = new HashSet<PropertyMatch>();
            matches.add(new PropertyMatch("class", null));
            matches.add(new PropertyMatch("this\\$.*", null));
            matches.add(new PropertyMatch("metaClass", "groovy.lang.MetaClass"));
            UNMAPPED_PROPERTIES = Collections.unmodifiableCollection(matches);
        }

        static class PropertyMatch {
            private final String namePattern;
            private final String typeName;

            public PropertyMatch(String namePattern, String typeName) {
                Assert.isTrue((namePattern != null || typeName != null ? 1 : 0) != 0, (String)"Either name patter or type name must be given!");
                this.namePattern = namePattern;
                this.typeName = typeName;
            }

            public boolean matches(String name, Class<?> type) {
                if (this.namePattern != null && !name.matches(this.namePattern)) {
                    return false;
                }
                return this.typeName == null || type.getName().equals(this.typeName);
            }
        }
    }

    private static final class PersistentPropertyCreator
    implements ReflectionUtils.FieldCallback {
        private final E entity;
        private final Map<String, PropertyDescriptor> descriptors;
        private final Map<String, PropertyDescriptor> remainingDescriptors;
        final /* synthetic */ AbstractMappingContext this$0;

        private PersistentPropertyCreator(E entity, Map<String, PropertyDescriptor> descriptors) {
            this.this$0 = var1_1;
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            Assert.notNull(descriptors, (String)"PropertyDescriptors must not be null!");
            this.entity = entity;
            this.descriptors = descriptors;
            this.remainingDescriptors = new HashMap<String, PropertyDescriptor>(descriptors);
        }

        public void doWith(Field field) {
            String fieldName = field.getName();
            ReflectionUtils.makeAccessible((Field)field);
            this.createAndRegisterProperty(field, this.descriptors.get(fieldName));
            this.remainingDescriptors.remove(fieldName);
        }

        public void addPropertiesForRemainingDescriptors() {
            for (PropertyDescriptor descriptor : this.remainingDescriptors.values()) {
                if (!PersistentPropertyFilter.INSTANCE.matches(descriptor)) continue;
                this.createAndRegisterProperty(null, descriptor);
            }
        }

        private void createAndRegisterProperty(Field field, PropertyDescriptor descriptor) {
            Object property = this.this$0.createPersistentProperty(field, descriptor, this.entity, this.this$0.simpleTypeHolder);
            if (property.isTransient()) {
                return;
            }
            if (field == null && !property.usePropertyAccess()) {
                return;
            }
            this.entity.addPersistentProperty(property);
            if (property.isAssociation()) {
                this.entity.addAssociation(property.getAssociation());
            }
            if (this.entity.getType().equals(property.getRawType())) {
                return;
            }
            for (TypeInformation<?> candidate : property.getPersistentEntityType()) {
                this.this$0.addPersistentEntity(candidate);
            }
        }
    }
}

