/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.util.Assert;

class DefaultProjectionInformation
implements ProjectionInformation {
    private final Class<?> projectionType;
    private final List<PropertyDescriptor> properties;

    public DefaultProjectionInformation(Class<?> type) {
        Assert.notNull(type, (String)"Projection type must not be null!");
        this.projectionType = type;
        this.properties = DefaultProjectionInformation.collectDescriptors(type);
    }

    @Override
    public Class<?> getType() {
        return this.projectionType;
    }

    @Override
    public List<PropertyDescriptor> getInputProperties() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : this.properties) {
            if (!this.isInputProperty(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.properties.equals(this.getInputProperties());
    }

    protected boolean isInputProperty(PropertyDescriptor descriptor) {
        return true;
    }

    private static List<PropertyDescriptor> collectDescriptors(Class<?> type) {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        result.addAll(Arrays.asList(BeanUtils.getPropertyDescriptors(type)));
        for (Class<?> interfaze : type.getInterfaces()) {
            result.addAll(DefaultProjectionInformation.collectDescriptors(interfaze));
        }
        return result;
    }
}

