/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import lombok.NonNull;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.util.ProxyUtils;

public class Example<T> {
    @NonNull
    private final T probe;
    @NonNull
    private final ExampleMatcher matcher;

    public static <T> Example<T> of(T probe) {
        return new Example<T>(probe, ExampleMatcher.matching());
    }

    public static <T> Example<T> of(T probe, ExampleMatcher matcher) {
        return new Example<T>(probe, matcher);
    }

    public T getProbe() {
        return this.probe;
    }

    public ExampleMatcher getMatcher() {
        return this.matcher;
    }

    public Class<T> getProbeType() {
        return ProxyUtils.getUserClass(this.probe.getClass());
    }

    public String toString() {
        return "Example(probe=" + this.getProbe() + ", matcher=" + this.getMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Example)) {
            return false;
        }
        Example other = (Example)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$probe = this.getProbe();
        T other$probe = other.getProbe();
        if (this$probe == null ? other$probe != null : !this$probe.equals(other$probe)) {
            return false;
        }
        ExampleMatcher this$matcher = this.getMatcher();
        ExampleMatcher other$matcher = other.getMatcher();
        return !(this$matcher == null ? other$matcher != null : !((Object)this$matcher).equals(other$matcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Example;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $probe = this.getProbe();
        result = result * 59 + ($probe == null ? 43 : $probe.hashCode());
        ExampleMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : ((Object)$matcher).hashCode());
        return result;
    }

    private Example(@NonNull T probe, @NonNull ExampleMatcher matcher) {
        if (probe == null) {
            throw new IllegalArgumentException("probe is null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("matcher is null");
        }
        this.probe = probe;
        this.matcher = matcher;
    }
}

