/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class ExampleMatcher {
    private final NullHandler nullHandler;
    private final StringMatcher defaultStringMatcher;
    private final PropertySpecifiers propertySpecifiers;
    private final Set<String> ignoredPaths;
    private final boolean defaultIgnoreCase;
    private final MatchMode mode;

    private ExampleMatcher() {
        this(NullHandler.IGNORE, StringMatcher.DEFAULT, new PropertySpecifiers(), Collections.emptySet(), false, MatchMode.ALL);
    }

    public static ExampleMatcher matching() {
        return ExampleMatcher.matchingAll();
    }

    public static ExampleMatcher matchingAny() {
        return new ExampleMatcher().withMode(MatchMode.ANY);
    }

    public static ExampleMatcher matchingAll() {
        return new ExampleMatcher().withMode(MatchMode.ALL);
    }

    public ExampleMatcher withIgnorePaths(String ... ignoredPaths) {
        Assert.notEmpty((Object[])ignoredPaths, (String)"IgnoredPaths must not be empty!");
        Assert.noNullElements((Object[])ignoredPaths, (String)"IgnoredPaths must not contain null elements!");
        LinkedHashSet<String> newIgnoredPaths = new LinkedHashSet<String>(this.ignoredPaths);
        newIgnoredPaths.addAll(Arrays.asList(ignoredPaths));
        return new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, newIgnoredPaths, this.defaultIgnoreCase, this.mode);
    }

    public ExampleMatcher withStringMatcher(StringMatcher defaultStringMatcher) {
        Assert.notNull(this.ignoredPaths, (String)"DefaultStringMatcher must not be empty!");
        return new ExampleMatcher(this.nullHandler, defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    public ExampleMatcher withIgnoreCase() {
        return this.withIgnoreCase(true);
    }

    public ExampleMatcher withIgnoreCase(boolean defaultIgnoreCase) {
        return new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, defaultIgnoreCase, this.mode);
    }

    public ExampleMatcher withMatcher(String propertyPath, MatcherConfigurer<GenericPropertyMatcher> matcherConfigurer) {
        Assert.hasText((String)propertyPath, (String)"PropertyPath must not be empty!");
        Assert.notNull(matcherConfigurer, (String)"MatcherConfigurer must not be empty!");
        GenericPropertyMatcher genericPropertyMatcher = new GenericPropertyMatcher();
        matcherConfigurer.configureMatcher(genericPropertyMatcher);
        return this.withMatcher(propertyPath, genericPropertyMatcher);
    }

    public ExampleMatcher withMatcher(String propertyPath, GenericPropertyMatcher genericPropertyMatcher) {
        Assert.hasText((String)propertyPath, (String)"PropertyPath must not be empty!");
        Assert.notNull((Object)genericPropertyMatcher, (String)"GenericPropertyMatcher must not be empty!");
        PropertySpecifiers propertySpecifiers = new PropertySpecifiers(this.propertySpecifiers);
        PropertySpecifier propertySpecifier = new PropertySpecifier(propertyPath);
        if (genericPropertyMatcher.ignoreCase != null) {
            propertySpecifier = propertySpecifier.withIgnoreCase(genericPropertyMatcher.ignoreCase);
        }
        if (genericPropertyMatcher.stringMatcher != null) {
            propertySpecifier = propertySpecifier.withStringMatcher(genericPropertyMatcher.stringMatcher);
        }
        if (genericPropertyMatcher.valueTransformer != null) {
            propertySpecifier = propertySpecifier.withValueTransformer(genericPropertyMatcher.valueTransformer);
        }
        propertySpecifiers.add(propertySpecifier);
        return new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    public ExampleMatcher withTransformer(String propertyPath, PropertyValueTransformer propertyValueTransformer) {
        Assert.hasText((String)propertyPath, (String)"PropertyPath must not be empty!");
        Assert.notNull((Object)propertyValueTransformer, (String)"PropertyValueTransformer must not be empty!");
        PropertySpecifiers propertySpecifiers = new PropertySpecifiers(this.propertySpecifiers);
        PropertySpecifier propertySpecifier = this.getOrCreatePropertySpecifier(propertyPath, propertySpecifiers);
        propertySpecifiers.add(propertySpecifier.withValueTransformer(propertyValueTransformer));
        return new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    public ExampleMatcher withIgnoreCase(String ... propertyPaths) {
        Assert.notEmpty((Object[])propertyPaths, (String)"PropertyPaths must not be empty!");
        Assert.noNullElements((Object[])propertyPaths, (String)"PropertyPaths must not contain null elements!");
        PropertySpecifiers propertySpecifiers = new PropertySpecifiers(this.propertySpecifiers);
        for (String propertyPath : propertyPaths) {
            PropertySpecifier propertySpecifier = this.getOrCreatePropertySpecifier(propertyPath, propertySpecifiers);
            propertySpecifiers.add(propertySpecifier.withIgnoreCase(true));
        }
        return new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    private PropertySpecifier getOrCreatePropertySpecifier(String propertyPath, PropertySpecifiers propertySpecifiers) {
        if (propertySpecifiers.hasSpecifierForPath(propertyPath)) {
            return propertySpecifiers.getForPath(propertyPath);
        }
        return new PropertySpecifier(propertyPath);
    }

    public ExampleMatcher withIncludeNullValues() {
        return this.withNullHandler(NullHandler.INCLUDE);
    }

    public ExampleMatcher withIgnoreNullValues() {
        return this.withNullHandler(NullHandler.IGNORE);
    }

    public ExampleMatcher withNullHandler(NullHandler nullHandler) {
        Assert.notNull((Object)((Object)nullHandler), (String)"NullHandler must not be null!");
        return new ExampleMatcher(nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    public NullHandler getNullHandler() {
        return this.nullHandler;
    }

    public StringMatcher getDefaultStringMatcher() {
        return this.defaultStringMatcher;
    }

    public boolean isIgnoreCaseEnabled() {
        return this.defaultIgnoreCase;
    }

    public boolean isIgnoredPath(String path) {
        return this.ignoredPaths.contains(path);
    }

    public Set<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public PropertySpecifiers getPropertySpecifiers() {
        return this.propertySpecifiers;
    }

    public boolean isAllMatching() {
        return this.mode.equals((Object)MatchMode.ALL);
    }

    public boolean isAnyMatching() {
        return this.mode.equals((Object)MatchMode.ANY);
    }

    public String toString() {
        return "ExampleMatcher(nullHandler=" + (Object)((Object)this.getNullHandler()) + ", defaultStringMatcher=" + (Object)((Object)this.getDefaultStringMatcher()) + ", propertySpecifiers=" + this.getPropertySpecifiers() + ", ignoredPaths=" + this.getIgnoredPaths() + ", defaultIgnoreCase=" + this.defaultIgnoreCase + ", mode=" + (Object)((Object)this.mode) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExampleMatcher)) {
            return false;
        }
        ExampleMatcher other = (ExampleMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NullHandler this$nullHandler = this.getNullHandler();
        NullHandler other$nullHandler = other.getNullHandler();
        if (this$nullHandler == null ? other$nullHandler != null : !((Object)((Object)this$nullHandler)).equals((Object)other$nullHandler)) {
            return false;
        }
        StringMatcher this$defaultStringMatcher = this.getDefaultStringMatcher();
        StringMatcher other$defaultStringMatcher = other.getDefaultStringMatcher();
        if (this$defaultStringMatcher == null ? other$defaultStringMatcher != null : !((Object)((Object)this$defaultStringMatcher)).equals((Object)other$defaultStringMatcher)) {
            return false;
        }
        PropertySpecifiers this$propertySpecifiers = this.getPropertySpecifiers();
        PropertySpecifiers other$propertySpecifiers = other.getPropertySpecifiers();
        if (this$propertySpecifiers == null ? other$propertySpecifiers != null : !((Object)this$propertySpecifiers).equals(other$propertySpecifiers)) {
            return false;
        }
        Set<String> this$ignoredPaths = this.getIgnoredPaths();
        Set<String> other$ignoredPaths = other.getIgnoredPaths();
        if (this$ignoredPaths == null ? other$ignoredPaths != null : !((Object)this$ignoredPaths).equals(other$ignoredPaths)) {
            return false;
        }
        if (this.defaultIgnoreCase != other.defaultIgnoreCase) {
            return false;
        }
        MatchMode this$mode = this.mode;
        MatchMode other$mode = other.mode;
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExampleMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NullHandler $nullHandler = this.getNullHandler();
        result = result * 59 + ($nullHandler == null ? 43 : ((Object)((Object)$nullHandler)).hashCode());
        StringMatcher $defaultStringMatcher = this.getDefaultStringMatcher();
        result = result * 59 + ($defaultStringMatcher == null ? 43 : ((Object)((Object)$defaultStringMatcher)).hashCode());
        PropertySpecifiers $propertySpecifiers = this.getPropertySpecifiers();
        result = result * 59 + ($propertySpecifiers == null ? 43 : ((Object)$propertySpecifiers).hashCode());
        Set<String> $ignoredPaths = this.getIgnoredPaths();
        result = result * 59 + ($ignoredPaths == null ? 43 : ((Object)$ignoredPaths).hashCode());
        result = result * 59 + (this.defaultIgnoreCase ? 79 : 97);
        MatchMode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    @ConstructorProperties(value={"nullHandler", "defaultStringMatcher", "propertySpecifiers", "ignoredPaths", "defaultIgnoreCase", "mode"})
    private ExampleMatcher(NullHandler nullHandler, StringMatcher defaultStringMatcher, PropertySpecifiers propertySpecifiers, Set<String> ignoredPaths, boolean defaultIgnoreCase, MatchMode mode) {
        this.nullHandler = nullHandler;
        this.defaultStringMatcher = defaultStringMatcher;
        this.propertySpecifiers = propertySpecifiers;
        this.ignoredPaths = ignoredPaths;
        this.defaultIgnoreCase = defaultIgnoreCase;
        this.mode = mode;
    }

    private ExampleMatcher withMode(MatchMode mode) {
        return this.mode == mode ? this : new ExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, mode);
    }

    private static enum MatchMode {
        ALL,
        ANY;

    }

    public static class PropertySpecifiers {
        private final Map<String, PropertySpecifier> propertySpecifiers = new LinkedHashMap<String, PropertySpecifier>();

        PropertySpecifiers() {
        }

        PropertySpecifiers(PropertySpecifiers propertySpecifiers) {
            this.propertySpecifiers.putAll(propertySpecifiers.propertySpecifiers);
        }

        public void add(PropertySpecifier specifier) {
            Assert.notNull((Object)specifier, (String)"PropertySpecifier must not be null!");
            this.propertySpecifiers.put(specifier.getPath(), specifier);
        }

        public boolean hasSpecifierForPath(String path) {
            return this.propertySpecifiers.containsKey(path);
        }

        public PropertySpecifier getForPath(String path) {
            return this.propertySpecifiers.get(path);
        }

        public boolean hasValues() {
            return !this.propertySpecifiers.isEmpty();
        }

        public Collection<PropertySpecifier> getSpecifiers() {
            return this.propertySpecifiers.values();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertySpecifiers)) {
                return false;
            }
            PropertySpecifiers other = (PropertySpecifiers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, PropertySpecifier> this$propertySpecifiers = this.propertySpecifiers;
            Map<String, PropertySpecifier> other$propertySpecifiers = other.propertySpecifiers;
            return !(this$propertySpecifiers == null ? other$propertySpecifiers != null : !((Object)this$propertySpecifiers).equals(other$propertySpecifiers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertySpecifiers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, PropertySpecifier> $propertySpecifiers = this.propertySpecifiers;
            result = result * 59 + ($propertySpecifiers == null ? 43 : ((Object)$propertySpecifiers).hashCode());
            return result;
        }
    }

    public static class PropertySpecifier {
        private final String path;
        private final StringMatcher stringMatcher;
        private final Boolean ignoreCase;
        private final PropertyValueTransformer valueTransformer;

        PropertySpecifier(String path) {
            Assert.hasText((String)path, (String)"Path must not be null/empty!");
            this.path = path;
            this.stringMatcher = null;
            this.ignoreCase = null;
            this.valueTransformer = NoOpPropertyValueTransformer.INSTANCE;
        }

        public PropertySpecifier withStringMatcher(StringMatcher stringMatcher) {
            Assert.notNull((Object)((Object)stringMatcher), (String)"StringMatcher must not be null!");
            return new PropertySpecifier(this.path, stringMatcher, this.ignoreCase, this.valueTransformer);
        }

        public PropertySpecifier withIgnoreCase(boolean ignoreCase) {
            return new PropertySpecifier(this.path, this.stringMatcher, ignoreCase, this.valueTransformer);
        }

        public PropertySpecifier withValueTransformer(PropertyValueTransformer valueTransformer) {
            Assert.notNull((Object)valueTransformer, (String)"PropertyValueTransformer must not be null!");
            return new PropertySpecifier(this.path, this.stringMatcher, this.ignoreCase, valueTransformer);
        }

        public String getPath() {
            return this.path;
        }

        public StringMatcher getStringMatcher() {
            return this.stringMatcher;
        }

        public Boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public PropertyValueTransformer getPropertyValueTransformer() {
            return this.valueTransformer == null ? NoOpPropertyValueTransformer.INSTANCE : this.valueTransformer;
        }

        public Object transformValue(Object source) {
            return this.getPropertyValueTransformer().convert(source);
        }

        @ConstructorProperties(value={"path", "stringMatcher", "ignoreCase", "valueTransformer"})
        private PropertySpecifier(String path, StringMatcher stringMatcher, Boolean ignoreCase, PropertyValueTransformer valueTransformer) {
            this.path = path;
            this.stringMatcher = stringMatcher;
            this.ignoreCase = ignoreCase;
            this.valueTransformer = valueTransformer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertySpecifier)) {
                return false;
            }
            PropertySpecifier other = (PropertySpecifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            StringMatcher this$stringMatcher = this.getStringMatcher();
            StringMatcher other$stringMatcher = other.getStringMatcher();
            if (this$stringMatcher == null ? other$stringMatcher != null : !((Object)((Object)this$stringMatcher)).equals((Object)other$stringMatcher)) {
                return false;
            }
            Boolean this$ignoreCase = this.getIgnoreCase();
            Boolean other$ignoreCase = other.getIgnoreCase();
            if (this$ignoreCase == null ? other$ignoreCase != null : !((Object)this$ignoreCase).equals(other$ignoreCase)) {
                return false;
            }
            PropertyValueTransformer this$valueTransformer = this.valueTransformer;
            PropertyValueTransformer other$valueTransformer = other.valueTransformer;
            return !(this$valueTransformer == null ? other$valueTransformer != null : !this$valueTransformer.equals(other$valueTransformer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertySpecifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            StringMatcher $stringMatcher = this.getStringMatcher();
            result = result * 59 + ($stringMatcher == null ? 43 : ((Object)((Object)$stringMatcher)).hashCode());
            Boolean $ignoreCase = this.getIgnoreCase();
            result = result * 59 + ($ignoreCase == null ? 43 : ((Object)$ignoreCase).hashCode());
            PropertyValueTransformer $valueTransformer = this.valueTransformer;
            result = result * 59 + ($valueTransformer == null ? 43 : $valueTransformer.hashCode());
            return result;
        }
    }

    public static enum NoOpPropertyValueTransformer implements PropertyValueTransformer
    {
        INSTANCE;


        public Object convert(Object source) {
            return source;
        }
    }

    public static interface PropertyValueTransformer
    extends Converter<Object, Object> {
    }

    public static enum StringMatcher {
        DEFAULT,
        EXACT,
        STARTING,
        ENDING,
        CONTAINING,
        REGEX;

    }

    public static class GenericPropertyMatchers {
        public static GenericPropertyMatcher ignoreCase() {
            return new GenericPropertyMatcher().ignoreCase();
        }

        public static GenericPropertyMatcher caseSensitive() {
            return new GenericPropertyMatcher().caseSensitive();
        }

        public static GenericPropertyMatcher contains() {
            return new GenericPropertyMatcher().contains();
        }

        public static GenericPropertyMatcher endsWith() {
            return new GenericPropertyMatcher().endsWith();
        }

        public static GenericPropertyMatcher startsWith() {
            return new GenericPropertyMatcher().startsWith();
        }

        public static GenericPropertyMatcher exact() {
            return new GenericPropertyMatcher().exact();
        }

        public static GenericPropertyMatcher storeDefaultMatching() {
            return new GenericPropertyMatcher().storeDefaultMatching();
        }

        public static GenericPropertyMatcher regex() {
            return new GenericPropertyMatcher().regex();
        }
    }

    public static class GenericPropertyMatcher {
        StringMatcher stringMatcher = null;
        Boolean ignoreCase = null;
        PropertyValueTransformer valueTransformer = NoOpPropertyValueTransformer.INSTANCE;

        public static GenericPropertyMatcher of(StringMatcher stringMatcher, boolean ignoreCase) {
            return new GenericPropertyMatcher().stringMatcher(stringMatcher).ignoreCase(ignoreCase);
        }

        public static GenericPropertyMatcher of(StringMatcher stringMatcher) {
            return new GenericPropertyMatcher().stringMatcher(stringMatcher);
        }

        public GenericPropertyMatcher ignoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public GenericPropertyMatcher ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public GenericPropertyMatcher caseSensitive() {
            this.ignoreCase = false;
            return this;
        }

        public GenericPropertyMatcher contains() {
            this.stringMatcher = StringMatcher.CONTAINING;
            return this;
        }

        public GenericPropertyMatcher endsWith() {
            this.stringMatcher = StringMatcher.ENDING;
            return this;
        }

        public GenericPropertyMatcher startsWith() {
            this.stringMatcher = StringMatcher.STARTING;
            return this;
        }

        public GenericPropertyMatcher exact() {
            this.stringMatcher = StringMatcher.EXACT;
            return this;
        }

        public GenericPropertyMatcher storeDefaultMatching() {
            this.stringMatcher = StringMatcher.DEFAULT;
            return this;
        }

        public GenericPropertyMatcher regex() {
            this.stringMatcher = StringMatcher.REGEX;
            return this;
        }

        public GenericPropertyMatcher stringMatcher(StringMatcher stringMatcher) {
            Assert.notNull((Object)((Object)stringMatcher), (String)"StringMatcher must not be null!");
            this.stringMatcher = stringMatcher;
            return this;
        }

        public GenericPropertyMatcher transform(PropertyValueTransformer propertyValueTransformer) {
            Assert.notNull((Object)propertyValueTransformer, (String)"PropertyValueTransformer must not be null!");
            this.valueTransformer = propertyValueTransformer;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericPropertyMatcher)) {
                return false;
            }
            GenericPropertyMatcher other = (GenericPropertyMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StringMatcher this$stringMatcher = this.stringMatcher;
            StringMatcher other$stringMatcher = other.stringMatcher;
            if (this$stringMatcher == null ? other$stringMatcher != null : !((Object)((Object)this$stringMatcher)).equals((Object)other$stringMatcher)) {
                return false;
            }
            Boolean this$ignoreCase = this.ignoreCase;
            Boolean other$ignoreCase = other.ignoreCase;
            if (this$ignoreCase == null ? other$ignoreCase != null : !((Object)this$ignoreCase).equals(other$ignoreCase)) {
                return false;
            }
            PropertyValueTransformer this$valueTransformer = this.valueTransformer;
            PropertyValueTransformer other$valueTransformer = other.valueTransformer;
            return !(this$valueTransformer == null ? other$valueTransformer != null : !this$valueTransformer.equals(other$valueTransformer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenericPropertyMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StringMatcher $stringMatcher = this.stringMatcher;
            result = result * 59 + ($stringMatcher == null ? 43 : ((Object)((Object)$stringMatcher)).hashCode());
            Boolean $ignoreCase = this.ignoreCase;
            result = result * 59 + ($ignoreCase == null ? 43 : ((Object)$ignoreCase).hashCode());
            PropertyValueTransformer $valueTransformer = this.valueTransformer;
            result = result * 59 + ($valueTransformer == null ? 43 : $valueTransformer.hashCode());
            return result;
        }
    }

    public static interface MatcherConfigurer<T> {
        public void configureMatcher(T var1);
    }

    public static enum NullHandler {
        INCLUDE,
        IGNORE;

    }
}

