/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyReferenceException
extends RuntimeException {
    private static final long serialVersionUID = -5254424051438976570L;
    private static final String ERROR_TEMPLATE = "No property %s found for type %s";
    private final String propertyName;
    private final TypeInformation<?> type;
    private final PropertyPath base;

    public PropertyReferenceException(String propertyName, TypeInformation<?> type, PropertyPath base) {
        Assert.hasText((String)propertyName);
        Assert.notNull(type);
        this.propertyName = propertyName;
        this.type = type;
        this.base = base;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeInformation<?> getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return String.format(ERROR_TEMPLATE, this.propertyName, this.type.getType().getName());
    }

    public PropertyPath getBaseProperty() {
        return this.base;
    }
}

