/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;

public enum ReflectionEntityInstantiator implements EntityInstantiator
{
    INSTANCE;

    private final int ARG_CACHE_SIZE = 100;
    private final ThreadLocal<Object[][]> objectPool = ThreadLocal.withInitial(() -> {
        Object[][] cached = new Object[100][];
        for (int i = 0; i < 100; ++i) {
            cached[i] = new Object[i];
        }
        return cached;
    });

    @Override
    public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
        PreferredConstructor<T, P> constructor = entity.getPersistenceConstructor();
        if (constructor == null) {
            try {
                Class<T> clazz = entity.getType();
                if (clazz.isArray()) {
                    Class<Object> ctype = clazz;
                    int dims = 0;
                    while (ctype.isArray()) {
                        ctype = ctype.getComponentType();
                        ++dims;
                    }
                    return (T)Array.newInstance(clazz, dims);
                }
                return (T)BeanUtils.instantiateClass(entity.getType());
            }
            catch (BeanInstantiationException e) {
                throw new MappingInstantiationException(entity, Collections.emptyList(), (Exception)((Object)e));
            }
        }
        int parameterCount = constructor.getConstructor().getParameterCount();
        Object[] params = parameterCount < 100 ? this.objectPool.get()[parameterCount] : new Object[parameterCount];
        int i = 0;
        for (PreferredConstructor.Parameter<Object, P> parameter : constructor.getParameters()) {
            params[i++] = provider.getParameterValue(parameter);
        }
        try {
            Object object = BeanUtils.instantiateClass(constructor.getConstructor(), (Object[])params);
            return (T)object;
        }
        catch (BeanInstantiationException e) {
            throw new MappingInstantiationException(entity, new ArrayList<Object>(Arrays.asList(params)), (Exception)((Object)e));
        }
        finally {
            Arrays.fill(params, null);
        }
    }
}

