/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.lang.annotation.Annotation;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationRevisionMetadata<N extends Number>
implements RevisionMetadata<N> {
    private final Object entity;
    private final Lazy<Optional<N>> revisionNumber;
    private final Lazy<Optional<LocalDateTime>> revisionDate;

    public AnnotationRevisionMetadata(Object entity, Class<? extends Annotation> revisionNumberAnnotation, Class<? extends Annotation> revisionTimeStampAnnotation) {
        Assert.notNull((Object)entity, (String)"Entity must not be null!");
        Assert.notNull(revisionNumberAnnotation, (String)"Revision number annotation must not be null!");
        Assert.notNull(revisionTimeStampAnnotation, (String)"Revision time stamp annotation must not be null!");
        this.entity = entity;
        this.revisionNumber = AnnotationRevisionMetadata.detectAnnotation(entity, revisionNumberAnnotation);
        this.revisionDate = AnnotationRevisionMetadata.detectAnnotation(entity, revisionTimeStampAnnotation);
    }

    @Override
    public Optional<N> getRevisionNumber() {
        return this.revisionNumber.get();
    }

    @Override
    public Optional<LocalDateTime> getRevisionDate() {
        return this.revisionDate.get();
    }

    @Override
    public <T> T getDelegate() {
        return (T)this.entity;
    }

    private static <T> Lazy<Optional<T>> detectAnnotation(Object entity, Class<? extends Annotation> annotationType) {
        return Lazy.of(() -> {
            AnnotationDetectionFieldCallback numberCallback = new AnnotationDetectionFieldCallback(annotationType);
            ReflectionUtils.doWithFields(entity.getClass(), (ReflectionUtils.FieldCallback)numberCallback);
            return (Optional)numberCallback.getValue(entity);
        });
    }
}

