/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    @Nullable
    private T value = null;
    private boolean resolved = false;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    @Override
    public T get() {
        T value = this.getNullable();
        if (value == null) {
            throw new IllegalStateException("Expected lazy evaluation to yield a non-null value but got null!");
        }
        return value;
    }

    @Nullable
    public T orElse(@Nullable T value) {
        return (T)this.orElseGet(() -> value);
    }

    @Nullable
    public T orElseGet(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Default value supplier must not be null!");
        T nullable = this.getNullable();
        return nullable == null ? supplier.get() : nullable;
    }

    public <S> Lazy<S> map(Function<T, S> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return Lazy.of(() -> function.apply(this.get()));
    }

    public <S> Lazy<S> flatMap(Function<T, Lazy<S>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return Lazy.of(() -> ((Lazy)function.apply(this.get())).get());
    }

    @Nullable
    private T getNullable() {
        T value = this.value;
        if (this.resolved) {
            return value;
        }
        this.value = value = this.supplier.get();
        this.resolved = true;
        return value;
    }

    @Generated
    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lazy)) {
            return false;
        }
        Lazy other = (Lazy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<T> this$supplier = this.supplier;
        Supplier<T> other$supplier = other.supplier;
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.resolved == other.resolved;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Lazy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<T> $supplier = this.supplier;
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.resolved ? 79 : 97);
        return result;
    }
}

