/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.time.LocalDateTime;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;

public final class Revision<N extends Number, T>
implements Comparable<Revision<N, ?>> {
    @NonNull
    private final RevisionMetadata<N> metadata;
    @NonNull
    private final T entity;

    public static <N extends Number, T> Revision<N, T> of(RevisionMetadata<N> metadata, T entity) {
        return new Revision<N, T>(metadata, entity);
    }

    public Optional<N> getRevisionNumber() {
        return this.metadata.getRevisionNumber();
    }

    public N getRequiredRevisionNumber() {
        return this.metadata.getRequiredRevisionNumber();
    }

    public Optional<LocalDateTime> getRevisionDate() {
        return this.metadata.getRevisionDate();
    }

    public LocalDateTime getRequiredRevisionDate() {
        return this.metadata.getRequiredRevisionDate();
    }

    @Override
    public int compareTo(@Nullable Revision<N, ?> that) {
        if (that == null) {
            return 1;
        }
        return Optionals.mapIfAllPresent(this.getRevisionNumber(), that.getRevisionNumber(), (left, right) -> ((Comparable)((Object)left)).compareTo(right)).orElse(-1);
    }

    public String toString() {
        return String.format("Revision %s of entity %s - Revision metadata %s", this.getRevisionNumber().map(Object::toString).orElse("<unknown>"), this.entity, this.metadata);
    }

    @NonNull
    public RevisionMetadata<N> getMetadata() {
        return this.metadata;
    }

    @NonNull
    public T getEntity() {
        return this.entity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)o;
        RevisionMetadata<N> this$metadata = this.getMetadata();
        RevisionMetadata<N> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        T this$entity = this.getEntity();
        T other$entity = other.getEntity();
        return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevisionMetadata<N> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        T $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        return result;
    }

    private Revision(@NonNull RevisionMetadata<N> metadata, @NonNull T entity) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        this.metadata = metadata;
        this.entity = entity;
    }
}

