/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.DefaultRepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class RepositoryConfigurationExtensionSupport
implements RepositoryConfigurationExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryConfigurationExtensionSupport.class);
    private static final String CLASS_LOADING_ERROR = "%s - Could not load type %s using class loader %s.";
    private static final String MULTI_STORE_DROPPED = "Spring Data {} - Could not safely identify store assignment for repository candidate {}.";

    @Override
    public String getModuleName() {
        return StringUtils.capitalize((String)this.getModulePrefix());
    }

    @Override
    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader) {
        return this.getRepositoryConfigurations(configSource, loader, false);
    }

    @Override
    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader, boolean strictMatchesOnly) {
        Assert.notNull(configSource, (String)"ConfigSource must not be null!");
        Assert.notNull((Object)loader, (String)"Loader must not be null!");
        HashSet<RepositoryConfiguration<T>> result = new HashSet<RepositoryConfiguration<T>>();
        for (BeanDefinition candidate : configSource.getCandidates(loader)) {
            RepositoryConfiguration<T> configuration = this.getRepositoryConfiguration(candidate, configSource);
            Class<?> repositoryInterface = this.loadRepositoryInterface(configuration, this.getConfigurationInspectionClassLoader(loader));
            if (repositoryInterface == null) {
                result.add(configuration);
                continue;
            }
            RepositoryMetadata metadata = AbstractRepositoryMetadata.getMetadata(repositoryInterface);
            if (!this.useRepositoryConfiguration(metadata)) continue;
            if (!strictMatchesOnly || configSource.usesExplicitFilters()) {
                result.add(configuration);
                continue;
            }
            if (!this.isStrictRepositoryCandidate(metadata)) continue;
            result.add(configuration);
        }
        return result;
    }

    @Override
    public String getDefaultNamedQueryLocation() {
        return String.format("classpath*:META-INF/%s-named-queries.properties", this.getModulePrefix());
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
    }

    protected abstract String getModulePrefix();

    @Override
    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptySet();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.emptySet();
    }

    @Nullable
    protected ClassLoader getConfigurationInspectionClassLoader(ResourceLoader loader) {
        return loader.getClassLoader();
    }

    public static String registerWithSourceAndGeneratedBeanName(BeanDefinitionRegistry registry, AbstractBeanDefinition bean, Object source) {
        bean.setSource(source);
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)bean, (BeanDefinitionRegistry)registry);
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
        return beanName;
    }

    public static void registerIfNotAlreadyRegistered(AbstractBeanDefinition bean, BeanDefinitionRegistry registry, String beanName, Object source) {
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        bean.setSource(source);
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
    }

    public static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }

    protected <T extends RepositoryConfigurationSource> RepositoryConfiguration<T> getRepositoryConfiguration(BeanDefinition definition, T configSource) {
        return new DefaultRepositoryConfiguration<T>(configSource, definition, this);
    }

    protected boolean isStrictRepositoryCandidate(RepositoryMetadata metadata) {
        Collection<Class<?>> types = this.getIdentifyingTypes();
        Class<?> repositoryInterface = metadata.getRepositoryInterface();
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(repositoryInterface)) continue;
            return true;
        }
        Class<?> domainType = metadata.getDomainType();
        Collection<Class<? extends Annotation>> annotations = this.getIdentifyingAnnotations();
        if (annotations.isEmpty()) {
            return true;
        }
        for (Class<? extends Annotation> annotationType : annotations) {
            if (AnnotationUtils.findAnnotation(domainType, annotationType) == null) continue;
            return true;
        }
        LOGGER.info(MULTI_STORE_DROPPED, (Object)this.getModuleName(), repositoryInterface);
        return false;
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return true;
    }

    @Nullable
    private Class<?> loadRepositoryInterface(RepositoryConfiguration<?> configuration, @Nullable ClassLoader classLoader) {
        String repositoryInterface = configuration.getRepositoryInterface();
        try {
            return ClassUtils.forName((String)repositoryInterface, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            LOGGER.warn(String.format(CLASS_LOADING_ERROR, this.getModuleName(), repositoryInterface, classLoader), e);
            return null;
        }
    }
}

