/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.data.util.Streamable;

final class LazyStreamable<T>
implements Streamable<T> {
    private final Supplier<? extends Stream<T>> stream;

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<T> stream() {
        return this.stream.get();
    }

    private LazyStreamable(Supplier<? extends Stream<T>> stream) {
        this.stream = stream;
    }

    public static <T> LazyStreamable<T> of(Supplier<? extends Stream<T>> stream) {
        return new LazyStreamable<T>(stream);
    }

    public Supplier<? extends Stream<T>> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyStreamable)) {
            return false;
        }
        LazyStreamable other = (LazyStreamable)o;
        Supplier<Stream<T>> this$stream = this.getStream();
        Supplier<Stream<T>> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<Stream<T>> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "LazyStreamable(stream=" + this.getStream() + ")";
    }
}

