/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveTypeDescriptor;
import org.springframework.data.util.ProxyUtils;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Completable;
import rx.Observable;

public final class ReactiveWrappers {
    private static final boolean PROJECT_REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean RXJAVA1_PRESENT = ClassUtils.isPresent((String)"rx.Completable", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean RXJAVA2_PRESENT = ClassUtils.isPresent((String)"io.reactivex.Flowable", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final Collection<ReactiveTypeDescriptor> REACTIVE_WRAPPERS;

    public static boolean isAvailable() {
        return Arrays.stream(ReactiveLibrary.values()).anyMatch(ReactiveWrappers::isAvailable);
    }

    public static boolean isAvailable(ReactiveLibrary reactiveLibrary) {
        Assert.notNull((Object)((Object)reactiveLibrary), (String)"Reactive library must not be null!");
        switch (reactiveLibrary) {
            case PROJECT_REACTOR: {
                return PROJECT_REACTOR_PRESENT;
            }
            case RXJAVA1: {
                return RXJAVA1_PRESENT;
            }
            case RXJAVA2: {
                return RXJAVA2_PRESENT;
            }
        }
        throw new IllegalArgumentException(String.format("Reactive library %s not supported", new Object[]{reactiveLibrary}));
    }

    public static boolean supports(Class<?> type) {
        return ReactiveWrappers.isWrapper(ProxyUtils.getUserClass(type));
    }

    public static boolean usesReactiveType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return Arrays.stream(type.getMethods()).flatMap(ReflectionUtils::returnTypeAndParameters).anyMatch(ReactiveWrappers::supports);
    }

    public static boolean isNoValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(ReactiveTypeDescriptor::isNoValue).orElse(false);
    }

    public static boolean isSingleValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(it -> !it.isMultiValue() && !it.isNoValue()).orElse(false);
    }

    public static boolean isMultiValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isSingleValueType(type) ? false : ReactiveWrappers.findDescriptor(type).map(ReactiveTypeDescriptor::isMultiValue).orElse(false);
    }

    public static Collection<Class<?>> getNoValueTypes() {
        return REACTIVE_WRAPPERS.stream().filter(ReactiveTypeDescriptor::isNoValue).map(ReactiveTypeDescriptor::getReactiveType).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getSingleValueTypes() {
        return REACTIVE_WRAPPERS.stream().filter(entry -> !entry.isMultiValue()).map(ReactiveTypeDescriptor::getReactiveType).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getMultiValueTypes() {
        return REACTIVE_WRAPPERS.stream().filter(ReactiveTypeDescriptor::isMultiValue).map(ReactiveTypeDescriptor::getReactiveType).collect(Collectors.toList());
    }

    private static boolean isWrapper(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isNoValueType(type) || ReactiveWrappers.isSingleValueType(type) || ReactiveWrappers.isMultiValueType(type);
    }

    private static Optional<ReactiveTypeDescriptor> findDescriptor(Class<?> type) {
        Assert.notNull(type, (String)"Wrapper type must not be null!");
        return REACTIVE_WRAPPERS.stream().filter(it -> ClassUtils.isAssignable((Class)it.getReactiveType(), (Class)type)).findFirst();
    }

    @Generated
    private ReactiveWrappers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ArrayList<ReactiveTypeDescriptor> reactiveWrappers = new ArrayList<ReactiveTypeDescriptor>(5);
        if (RXJAVA1_PRESENT) {
            reactiveWrappers.add(ReactiveTypeDescriptor.singleRequiredValue(rx.Single.class));
            reactiveWrappers.add(ReactiveTypeDescriptor.noValue(Completable.class, Completable::complete));
            reactiveWrappers.add(ReactiveTypeDescriptor.multiValue(Observable.class, Observable::empty));
        }
        if (RXJAVA2_PRESENT) {
            reactiveWrappers.add(ReactiveTypeDescriptor.singleRequiredValue(Single.class));
            reactiveWrappers.add(ReactiveTypeDescriptor.singleOptionalValue(Maybe.class, Maybe::empty));
            reactiveWrappers.add(ReactiveTypeDescriptor.noValue(io.reactivex.Completable.class, io.reactivex.Completable::complete));
            reactiveWrappers.add(ReactiveTypeDescriptor.multiValue(Flowable.class, Flowable::empty));
            reactiveWrappers.add(ReactiveTypeDescriptor.multiValue(io.reactivex.Observable.class, io.reactivex.Observable::empty));
        }
        if (PROJECT_REACTOR_PRESENT) {
            reactiveWrappers.add(ReactiveTypeDescriptor.singleOptionalValue(Mono.class, Mono::empty));
            reactiveWrappers.add(ReactiveTypeDescriptor.multiValue(Flux.class, Flux::empty));
            reactiveWrappers.add(ReactiveTypeDescriptor.multiValue(Publisher.class, Flux::empty));
        }
        REACTIVE_WRAPPERS = Collections.unmodifiableCollection(reactiveWrappers);
    }

    static enum ReactiveLibrary {
        PROJECT_REACTOR,
        RXJAVA1,
        RXJAVA2;

    }
}

