/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public interface RepositoryFragment<T> {
    public static <T> RepositoryFragment<T> implemented(T implementation) {
        return new ImplementedRepositoryFragment(Optional.empty(), implementation);
    }

    public static <T> RepositoryFragment<T> implemented(Class<T> interfaceClass, T implementation) {
        return new ImplementedRepositoryFragment<T>(Optional.of(interfaceClass), implementation);
    }

    public static <T> RepositoryFragment<T> structural(Class<T> interfaceOrImplementation) {
        return new StructuralRepositoryFragment<T>(interfaceOrImplementation);
    }

    default public boolean hasMethod(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return ReflectionUtils.findMethod(this.getSignatureContributor(), (String)method.getName(), (Class[])method.getParameterTypes()) != null;
    }

    default public Optional<T> getImplementation() {
        return Optional.empty();
    }

    default public Stream<Method> methods() {
        return Arrays.stream(this.getSignatureContributor().getMethods());
    }

    public Class<?> getSignatureContributor();

    public RepositoryFragment<T> withImplementation(T var1);

    public static class ImplementedRepositoryFragment<T>
    implements RepositoryFragment<T> {
        private final Optional<Class<T>> interfaceClass;
        private final T implementation;

        public ImplementedRepositoryFragment(Optional<Class<T>> interfaceClass, T implementation) {
            Assert.notNull(interfaceClass, (String)"Interface class must not be null!");
            Assert.notNull(implementation, (String)"Implementation object must not be null!");
            interfaceClass.ifPresent(it -> Assert.isTrue((boolean)ClassUtils.isAssignableValue((Class)it, (Object)implementation), () -> String.format("Fragment implementation %s does not implement %s!", ClassUtils.getQualifiedName(implementation.getClass()), ClassUtils.getQualifiedName((Class)it))));
            this.interfaceClass = interfaceClass;
            this.implementation = implementation;
        }

        @Override
        public Class<?> getSignatureContributor() {
            return this.interfaceClass.orElse(this.implementation.getClass());
        }

        @Override
        public Optional<T> getImplementation() {
            return Optional.of(this.implementation);
        }

        @Override
        public RepositoryFragment<T> withImplementation(T implementation) {
            return new ImplementedRepositoryFragment<T>(this.interfaceClass, implementation);
        }

        public String toString() {
            return String.format("ImplementedRepositoryFragment %s%s", this.interfaceClass.map(ClassUtils::getShortName).map(it -> it + ":").orElse(""), ClassUtils.getShortName(this.implementation.getClass()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImplementedRepositoryFragment)) {
                return false;
            }
            ImplementedRepositoryFragment other = (ImplementedRepositoryFragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<Class<T>> this$interfaceClass = this.interfaceClass;
            Optional<Class<T>> other$interfaceClass = other.interfaceClass;
            if (this$interfaceClass == null ? other$interfaceClass != null : !((Object)this$interfaceClass).equals(other$interfaceClass)) {
                return false;
            }
            Optional<T> this$implementation = this.getImplementation();
            Optional<T> other$implementation = other.getImplementation();
            return !(this$implementation == null ? other$implementation != null : !((Object)this$implementation).equals(other$implementation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImplementedRepositoryFragment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<Class<T>> $interfaceClass = this.interfaceClass;
            result = result * 59 + ($interfaceClass == null ? 43 : ((Object)$interfaceClass).hashCode());
            Optional<T> $implementation = this.getImplementation();
            result = result * 59 + ($implementation == null ? 43 : ((Object)$implementation).hashCode());
            return result;
        }
    }

    public static class StructuralRepositoryFragment<T>
    implements RepositoryFragment<T> {
        @NonNull
        private final Class<T> interfaceOrImplementation;

        @Override
        public Class<?> getSignatureContributor() {
            return this.interfaceOrImplementation;
        }

        @Override
        public RepositoryFragment<T> withImplementation(T implementation) {
            return new ImplementedRepositoryFragment<T>(Optional.of(this.interfaceOrImplementation), implementation);
        }

        public String toString() {
            return String.format("StructuralRepositoryFragment %s", ClassUtils.getShortName(this.interfaceOrImplementation));
        }

        public StructuralRepositoryFragment(@NonNull Class<T> interfaceOrImplementation) {
            if (interfaceOrImplementation == null) {
                throw new IllegalArgumentException("interfaceOrImplementation is marked @NonNull but is null");
            }
            this.interfaceOrImplementation = interfaceOrImplementation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructuralRepositoryFragment)) {
                return false;
            }
            StructuralRepositoryFragment other = (StructuralRepositoryFragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$interfaceOrImplementation = this.interfaceOrImplementation;
            Class<T> other$interfaceOrImplementation = other.interfaceOrImplementation;
            return !(this$interfaceOrImplementation == null ? other$interfaceOrImplementation != null : !this$interfaceOrImplementation.equals(other$interfaceOrImplementation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StructuralRepositoryFragment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $interfaceOrImplementation = this.interfaceOrImplementation;
            result = result * 59 + ($interfaceOrImplementation == null ? 43 : $interfaceOrImplementation.hashCode());
            return result;
        }
    }
}

